#include "mbed.h"
#include "oled_i2c.h"
#include "oled_font.h"
#include "test_TMP102.h"

DigitalOut myled(LED2);

// for LPCXpresso LPC1114 board
// UART TX: xp9, dp16
// UART RX: xp10, dp15
// *************************************
// ** serial port: 9600, 8, N, 1, N
// *************************************
//Serial pc(xp9, xp10);
I2C i2c(dp5, dp27);           // NXP LPC1114
//I2C i2c(I2C_SDA, I2C_SCL);    // ST F401
//I2C i2c(PA_10, PA_9);           // ST L031
oled_i2c oled(i2c);
test_TMP102 temp1(i2c);

int main() {
    myled = 1;
    printf("LPC1114 demo \r\n");
    i2c.frequency(1000 * 1000);
    
    // ------------ tmp102 --------------
    temp1.setExtendedMode(1);
    temp1.setConversionRate(2);
    temp1.sleep();
    
    // ------------ oled ----------------
    oled.init_oled();
    //oled.fillScr();
    
    while(1)
    {
        myled = 1;
        
        temp1.oneShot();
        float t1 = temp1;
        
        //oled.clrScr();
        oled.setFont(BigNumbers);
        //oled.print("27", 20, 10);
        //oled.printNumI(27, 0, 0);
        oled.printNumF(t1, 2, 0, 0);
        oled.setFont(SmallFont);
        oled.print("~c", 60, 30);
        oled.update();
        myled = 0;
        wait(0.5);
    }
}
