#include "mbed.h"
#include "oled_i2c.h"
#include "oled_font.h"

DigitalOut myled(LED2);

// make oled_i2c instance using I2C object.
// with default slave address 0x78 (0x3C in 7bit format)
// test ok with SSD1306 I2C 128*64 oled screen
I2C i2c(dp5,dp27);   // for LPC1114 or LPC1115
oled_i2c oled(i2c);

int main()
{
    myled = 1;
    printf("LPC1114 demo \r\n");
    
    i2c.frequency(1000 * 1000);
    oled.init_oled();

    oled.setFont(BigNumbers);
    //oled.print("27", 20, 10);
    //oled.printNumI(27, 0, 0);
    oled.printNumF(27.45, 2, 0, 0);
    oled.setFont(SmallFont);
    oled.print("~c", 60, 30);
    oled.update();

    myled = 0;
    while(1);
}
