#include "mbed.h"
#include "eeprom.h"

#define BUFFER_SIZE  64

DigitalOut myled(LED2);

// for LPCXpresso LPC1114 board
// UART TX: xp9, dp16
// UART RX: xp10, dp15
// *************************************
// ** serial port: 9600, 8, N, 1, N
// *************************************
//Serial pc(xp9, xp10);
I2C i2c(dp5, dp27);     // for NXP LPC111x
eeprom epm(i2c);

// import!!! must prefix 3 bytes for memory address
uint8_t buffer[BUFFER_SIZE + 3]; 

int main()
{
    myled = 1;
    printf("LPC1114 demo.\n\r");

    // -------- page write --------------------
    for (int i=0; i<BUFFER_SIZE; i++)
        buffer[i+3] = i;     // for prefix 3 memory address

    epm.page_write(12288, TWO_BYTES_ADDRESS, buffer, BUFFER_SIZE);
    //wait(0.008);
    epm.ack_polling();

    // -------- current read ------------------
    printf("below shold be 00 01 ... 3f\n\r");
    epm.write_address(12288, TWO_BYTES_ADDRESS);

    for (int i=0; i<BUFFER_SIZE; i++) {
      printf("%.2x ", epm.current_read());
    }
    printf("\n\r");
    
    // -------- byte write --------------------
    epm.byte_write(12288, TWO_BYTES_ADDRESS, 0xAA);
    epm.ack_polling();
    
    // -------- sequential read ---------------
    printf("below shold be aa 01 02 ... 3f\n\r");
    epm.write_address(12288, TWO_BYTES_ADDRESS);
  
    uint8_t data[BUFFER_SIZE];
    epm.sequential_read(data, BUFFER_SIZE);
    for (int i=0; i<BUFFER_SIZE; i++) {
        printf("%.2x ", data[i]);
    }
    printf("\n\r");

    // -------- byte write --------------------
    epm.byte_write(12289, TWO_BYTES_ADDRESS, 0xBB);
    epm.ack_polling();

    // -------- random read -------------------
    printf("below shold be aa bb 02 03 ... 3f\n\r");
    epm.random_read(12288, TWO_BYTES_ADDRESS, buffer, 64);
    for (int i=0; i<64; i++) {
        printf("%.2x ", buffer[i]);
    }
    printf("\n\r");

    myled = 0;
    while(1);
}
