/*
#include "mbed.h"
#include "Adafruit_SSD1306.h"

DigitalOut led1(LED_RED);

// SPI sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(1000000); 
        //frequency(100000);
        //start();
    };
};

I2CPreInit myI2C(PB_9,PB_8);
Adafruit_SSD1306_I2c myOled(myI2C,NC,0x78,64,128);

int main()
{   
    uint16_t x=0;
 
    myOled.begin();
    myOled.printf("%ux%u Hellow World\r\n", myOled.width(), myOled.height());
    myOled.display();

    while(1)
    {
        led1 = !led1;
        myOled.printf("%u\r",x);
        myOled.display();
        x = x + 1;                  
        wait(1.0);
    }
}

*/





#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "test_TMP102.h"

class I2CPreInit : public I2C
{
public:
 I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
 {
    frequency(1000000);
    //start();
 };
};
 
//I2CPreInit myI2C(PB_9,PB_8);
I2CPreInit myI2C(I2C_SDA, I2C_SCL);
//I2CPreInit myI2C(dp5, dp27);
Adafruit_SSD1306_I2c myOled(myI2C,NC,0x78,64,128);

test_TMP102 temp1(myI2C);
 
int main()
{ 
    uint16_t x=0;
  
    // ------------ tmp102 --------------
    temp1.setExtendedMode(1);
    temp1.setConversionRate(2);
    temp1.sleep();
    
    // ------------  oled  --------------
    myOled.begin();
    myOled.clearDisplay();
    myOled.display();
    wait(0.1);
      
    myOled.fillCircle(64, 42, 10, 1); 
    myOled.display();
    wait(1);
    myOled.fillCircle(64, 42, 5, 0); 
    myOled.display();
    wait(1);
      
    myOled.clearDisplay();
    myOled.display();
    wait(0.1);
      
    myOled.printf("\r\n OLED %ux%u \r\n\r\n Hello World\r\n\n", myOled.width(), myOled.height());
      
    myOled.drawRect(0, 0, 128, 64,1);
    myOled.display();
    wait(0.5);
    while(1)
    {
        temp1.oneShot();
        float t1 = temp1;
        
        //myOled.printf("%u\r ",x);
        myOled.printf(" Temp: %.3f ~c\r", t1);

        myOled.drawRect(0, 0, 128, 64,1); 
      
        myOled.display();
        x = x + 1; 
        wait(0.5);
    }
}





