#include "test_TMP102.h"

test_TMP102::test_TMP102(PinName sda, PinName scl, char address)
    : i2c_p(new I2C(sda, scl)), i2c(*i2c_p),adr(address)
{
    init();
}
test_TMP102::test_TMP102(I2C &i2c_obj, char address)
    : i2c_p(NULL), i2c(i2c_obj), adr(address)
{
    init();
}

test_TMP102::~test_TMP102()
{
    if(NULL!=i2c_p)
        delete i2c_p;
}

void test_TMP102::init(void)
{
}

float test_TMP102::read(void)
{
    char reg[2]= {0,0};
    char pointer = TMP102_Temp;
    i2c.write(adr, &pointer, 1); //Pointer to the temperature register
    i2c.read(adr, reg, 2); // read two bytes data

    int16_t res;
    // Bit 0 of second byte will always be 0 in 12-bit readings and 1 in 13-bit
    if(reg[1]&0x01)  // 13 bit mode
    {
        // combine bytes to create a signed int
        res = ((int8_t)reg[0] << 5) | ((uint8_t)reg[1] >> 3);
        // Temperature data can be + or -, if it should be negative,
        // convert 13 bit to 16 bit and use the 2s compliment.
        if (res > 0xFFF) res |= 0xE000;
    } else  // 12 bit mode
    {
        res = ((int8_t)reg[0] << 4) | ((uint8_t)reg[1] >> 4);
        if (res > 0x7FF) res |= 0xF000;
    }
    
    float temp = (float)(res * 0.0625);
    return temp;
}

float test_TMP102::readTempC(void)
{
    return read();
}

float test_TMP102::readTempF(void)
{
    return (float)((double)readTempC()*9.0/5.0 + 32.0);
}

void test_TMP102::setConversionRate(char rate)
{
    char reg[2] = {0, 0};
    char pointer = TMP102_Conf;
    rate = rate & 0x03;              // make sure rate is not set higher than 3.
    
    i2c.write(adr, &pointer, 1);    //Pointer to the conf register
    i2c.read(adr, reg, 2);          // read two bytes data
    
    reg[1] &= 0x3F;         // Clear CR0/1 (bit 6 and 7 of second byte)
    reg[1] |= rate << 6;    // Shift in new conversion rate
    
    char data[3];
    data[0] = pointer;
    data[1] = reg[0];
    data[2] = reg[1];
    i2c.write(adr, data, 3);
}

void test_TMP102::setExtendedMode(bool mode)
{
    char reg[2] = {0, 0};
    char pointer = TMP102_Conf;
    
    i2c.write(adr, &pointer, 1);    //Pointer to the conf register
    i2c.read(adr, reg, 2);          // read two bytes data
    
    reg[1] &= 0xEF;     // Clear EM (bit 4 of second byte)
    reg[1] |= mode<<4;  // Shift in new exentended mode bit
    
    char data[3];
    data[0] = pointer;
    data[1] = reg[0];
    data[2] = reg[1];
    i2c.write(adr, data, 3);
}

test_TMP102::operator float(void)
{
    return (read());
}

void test_TMP102::sleep(void)
{
    char reg;
    char pointer = TMP102_Conf;
    i2c.write(adr, &pointer, 1); //Pointer to the conf register
    i2c.read(adr, &reg, 1); // read one byte data
    
    reg |= 0x01;            // set SD (bit 0 of first byte)
    
    char data[2];
    data[0] = pointer;
    data[1] = reg;
    i2c.write(adr, data, 2);
}

void test_TMP102::wakeup(void)
{
    char reg;
    char pointer = TMP102_Conf;
    i2c.write(adr, &pointer, 1); //Pointer to the conf register
    i2c.read(adr, &reg, 1); // read one byte data
    
    reg &= 0xFE;    // Clear SD (bit 0 of first byte)
    
    char data[2];
    data[0] = pointer;
    data[1] = reg;
    i2c.write(adr, data, 2);
}

void test_TMP102::oneShot(void)
{
    char reg;
    char pointer = TMP102_Conf;
    i2c.write(adr, &pointer, 1); //Pointer to the conf register
    i2c.read(adr, &reg, 1); // read one byte data
    
    reg |= 0x80;    // Set OS (bit 7 of first byte)
    
    char data[2];
    data[0] = pointer;
    data[1] = reg;
    i2c.write(adr, data, 2);
    
    do {
        wait(0.026);
        i2c.read(adr, &reg, 1);
        reg &= 0x80;
    } while (reg == 0);
}
