#include "mbed.h"
#include "Utils.h"

//SDBlockDevice bd(Flash_MOSI, Flash_MISO, Flash_SCK, Flash_CS);
SPIFBlockDevice bd(Flash_MOSI, Flash_MISO, Flash_SCK, Flash_CS);

FATFileSystem Root("Root");

int Exist_Val = 0;

//Init des PIN i2c pour l'eeprom
I2C I2C_EEPROM(SDA_PIN, SCL_PIN);

void return_error(int ret_val)
{
    Exist_Val = 0;
    if (ret_val) {
        DEEP_DEBUG("  Problème Flash = %d\r\n", ret_val);
        Exist_Val = 0;
    } else {
        DEEP_DEBUG("  Flash -> OK.\r\n");
        Exist_Val = 1;
    }
    wait_ms(100);
}

void errno_error(void* ret_val)
{
    Exist_Val = 0;
    if (ret_val == NULL) {
        DEEP_DEBUG("  Problème Flash = %d \r\n", errno);
        Exist_Val = 0;
    } else {
        DEEP_DEBUG("  Flash -> OK.\r\n");
        Exist_Val = 1;
    }
    wait_ms(100);
}

void UTILS::Flash_Infos(USBSerial *serial_port)
{
    serial_port->printf("?\r\n");
    
    serial_port->printf("  Flash size         : %llu Mb\r\n", bd.size() / 1048576);
    serial_port->printf("  Flash read size    : %llu\r\n", bd.get_read_size());
    serial_port->printf("  Flash program size : %llu\r\n", bd.get_program_size());
    serial_port->printf("  Flash erase size   : %llu\r\n", bd.get_erase_size());
}

void UTILS::Get_File_Size(USBSerial *serial_port, char* File_Name)
{
    serial_port->printf("?\r\n");
    
    char filename[50];
    sprintf(filename, "/Root/%s", File_Name);

    FILE* fd = fopen(filename, "r");
    errno_error(fd);

    fseek(fd, 0, SEEK_END);
    int size = ftell(fd);
    fseek(fd, 0, SEEK_SET);

    fclose(fd);

    serial_port->printf("  Taille du fichier %s = %d Kb\r\n", filename, size / 1024);
}

void UTILS::Store_A_Val(float Val_To_Store, char* File_Name)
{

    char filename[50];
    sprintf(filename, "/Root/%s", File_Name);

    FILE* fd = fopen(filename, "w");
    errno_error(fd);
    fprintf(fd, "%f\r\n", Val_To_Store);
    fclose(fd);

    DEEP_DEBUG("  \r\n  %s sauvegardée = %f\r\n", filename, Val_To_Store);

}

float UTILS::Read_A_Val(char* File_Name)
{
    char buffer[10] = {0};
    char c = {0};
    char *token;
    int i = 0;

    char filename[50];
    sprintf(filename, "/Root/%s", File_Name);

    DEEP_DEBUG("  \n  Récupération de %s...\r\n", filename);

    FILE* fd = fopen(filename, "r");
    errno_error(fd);

    while ((c != '\n') && (i < 10)) {
        c = fgetc(fd);
        buffer[i] = c;
        i++;
    }

    token = strtok(buffer, "\n");

    float val = atof(token);

    DEEP_DEBUG("  Valeur Récupérée = %f\r\n", val);

    fclose(fd);

    return val;
}


void UTILS::Write_Flash_File(char* To_Store, char* File_Name)
{
    char filename[50];
    sprintf(filename, "/Root/%s", (string)File_Name);

    FILE* fd = fopen(filename, "a");

    errno_error(fd);
    fprintf(fd, "%s\r\n", To_Store);
    fclose(fd);

    DEEP_DEBUG("  Enregistrement de %s OK\r\n\r\n", filename);
}

/*
void UTILS::Read_Flash_File(char* File_Name)
{
    char filename[50];
    sprintf(filename, "/Root/%s", File_Name);

    FILE* fd = fopen(filename, "r");
    errno_error(fd);

    //printf("  Contenu du fichier :\r\n\r\n");
    char buff[100] = {0};

    while (!feof(fd)) {
        int size = fread(&buff[0], 1, 15, fd);
        fwrite(&buff[0], 1, size, stdout);
    }
    //printf("\r\n  Fin du fichier.\r\n");
    fclose(fd);

}
*/

void UTILS::Read_Flash_File(USBSerial *serial_port, char* File_Name)
{   
    serial_port->printf("?\r\n");
    
    if (File_Exist(File_Name)) {
    char filename[50];
    sprintf(filename, "/Root/%s", File_Name);    
    FILE* fd = fopen(filename, "r");
    errno_error(fd);
    char s1[100];
    printf("\r\n");
    DEBUG("  Contenu du fichier :\r\n\r\n");
    while (!feof(fd)) {
        memset(s1, 0, sizeof(s1));
        fgets(s1, sizeof(s1), fd);
        serial_port->printf("%s", s1);
    }
    fclose(fd);
    DEBUG("\r\n  Fin du fichier.\r\n");
    }
}

bool UTILS::File_Exist(char* File_Name)
{
    char filename[50];
    sprintf(filename, "/Root/%s", File_Name);

    FILE* fd = fopen(filename, "r");
    errno_error(fd);

    if (Exist_Val == 0) {
        DEBUG("  Le fichier %s n'existe pas....\r\n", filename);
        fclose(fd);
        return false;
    }

    if (Exist_Val == 1) {
        fclose(fd);
        return true;
    }
}

void UTILS::Delete_Flash_File(char* File_Name)
{
    char filename[50];
    sprintf(filename, "%s", File_Name);
    int error = 0;
    error = Root.remove(filename);
    return_error(error);

    DEBUG("  Fichier %s effacé.\r\n", filename);
}

void UTILS::Clean_Flash()
{
    DEBUG("  Nettoyage de la Flash.\r\n");
    //float Saved_O2 = UTILS::Read_A_Val("Calibration_O2");
    int Saved_Motor_P = (int)UTILS::Read_A_Val("Servo_Poumon.sys");
    int Saved_Motor_F = (int)UTILS::Read_A_Val("Servo_Fuite.sys");
    int ARNSRS_ID = (int)UTILS::Read_A_Val("ARNSRS_ID.sys");
    UTILS::UnMount_Flash();
    UTILS::Format_Flash();
    UTILS::Mount_Flash();
    //UTILS::Store_A_Val(Saved_O2, "Calibration_O2");
    UTILS::Store_A_Val(Saved_Motor_P, "Servo_Poumon.sys");
    UTILS::Store_A_Val(Saved_Motor_F, "Servo_Fuite.sys");
    UTILS::Store_A_Val(ARNSRS_ID, "ARNSRS_ID.sys");
    DEBUG("  Flash nettoyée.\r\n");
    DEBUG("  Redémmarage code.\r\n");
    UTILS::UnMount_Flash();
    NVIC_SystemReset();
}

void UTILS::Clean_Flash_All()
{
    DEBUG("  Nettoyage complet de la Flash.\r\n");
    UTILS::UnMount_Flash();
    UTILS::Format_Flash();
    NVIC_SystemReset();
}

void UTILS::Rename_Flash_File(char* Old_File_Name, char* New_File_Name)
{
    char Oldfilename[50];
    sprintf(Oldfilename, "/Root/%s", Old_File_Name);
    char Newfilename[50];
    sprintf(Newfilename, "/Root/%s", New_File_Name);

    int error = 0;
    error = Root.rename(Oldfilename, Newfilename);
    return_error(error);

    DEBUG("  Fichier %s renommé en %s.\r\n", Oldfilename, Newfilename);
}

void UTILS::Mount_Flash()
{
    //Montage Flash
    DEBUG("  Montage Flash \"/Root\". \r\n\r\n");
    int error = 0;
    error = Root.mount(&bd);
    return_error(error);
    if (error > 0) {
        //On re format s'il n'y a as de file system...normalement une seul fois...
        DEBUG("Pas de File system, on format... ");
        UTILS::Format_Flash();
    }
}

void UTILS::UnMount_Flash()
{
    //De Montage Flash
    DEBUG("  Demontage Flash \"/Root\". \r\n\r\n");
    int error = 0;
    error = Root.unmount();
    return_error(error);
}

void UTILS::Format_Flash()
{
    //Formatage Flash
    DEBUG("  Formatage Flash\r\n\r\n");
    int error = 0;
    error = FATFileSystem::format(&bd);
    return_error(error);
}

void UTILS::Dir_Flash(USBSerial *serial_port, char* Dir_Name)
{
    int error = 0;
    int nb = 0;
    DEEP_DEBUG("\r\n  Ouverture du répertoire %s\r\n", Dir_Name);
    char Dirname[50];
    sprintf(Dirname, "/Root/%s", Dir_Name);

    DIR* dir = opendir(Dirname);

    struct dirent* de;
    DEBUG("  Fichiers du répertoire :\r\n\r\n");
    while((de = readdir(dir)) != NULL) {
        serial_port->printf("%s\r\n", &(de->d_name)[0]);
        fflush(stdout);
        nb++;
    }
    
    serial_port->printf("!\r\n");
    
    DEBUG("\r\n  Nombre de fichiers = %d\r\n", nb);
    DEEP_DEBUG("  Fermeture du répertoire.\r\n");
    error = closedir(dir);
    return_error(error);
}


int UTILS::File_Index()
{
    int error = 0;
    int nb = 0;

    DIR* dir = opendir("/Root/");
    struct dirent* de;
    while((de = readdir(dir)) != NULL) {
        nb++;
    }
    error = closedir(dir);
    return_error(error);

    return nb - 2;
}

//Remapping d'une valeur dans une autre échelle
float UTILS::Remap(float x, float in_min, float in_max, float out_min, float out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

//Contraint une valeur entre deux limites
float UTILS::constrain(float x, float a, float b)
{
    if(x < a) {
        return a;
    } else if(b < x) {
        return b;
    } else
        return x;
}

void UTILS::Help(USBSerial *serial_port)
{
    serial_port->printf("?\r\n");
    
    serial_port->printf("  COMMANDES GENERALES\r\n\r\n");
    /*
    serial_port->printf("  help             =    liste des commandes.\r\n");
    serial_port->printf("  start            =    démmarage des sorties moniteur.\r\n");
    serial_port->printf("  stop             =    arrêt des sorties moniteur.\r\n");
    serial_port->printf("  time X           =    met la RTC à l'heure, X en UNIX TIME.\n\r");
    */
    serial_port->printf("  ARNSRS_ID X      =    entrée de l'identifiant de l'appareil X.\r\n");
    /*
    serial_port->printf("  sleep            =    mise en veille.\r\n");
    serial_port->printf("  reset            =    reset de la carte.\r\n\r\n");
    serial_port->printf("  COMMANDES MEMOIRE\r\n\r\n");
    serial_port->serial_port->printf("  rec              =    démarrage / arrêt enregistrement.\r\n");
    serial_port->printf("  flash_i          =    informations sur la flash.\r\n");
    serial_port->printf("  flash_u          =    démonte la flash. A faire avant de débrancher ou recharger un code.\r\n");
    serial_port->printf("  flash_m          =    monte la flash.\r\n");
    serial_port->printf("  flash_c          =    nettoyage flash, suppression des fichiers LOG.\r\n");
    serial_port->printf("  dir              =    liste des fichiers de la flash.\r\n");
    serial_port->printf("  del X            =    effacer le fichier LOG_X.\r\n");
    serial_port->printf("  get X            =    récupérer le contenu du fichier LOG_X.\r\n");
    serial_port->printf("  file_s X         =    récupérer la taille du fichier LOG_X.\r\n");
    //serial_port->printf("  file_i X         =    récupérer les informations sur le fichier LOG_X.\r\n");
    serial_port->printf("  COMMANDES MOTEURS\r\n\r\n");
    serial_port->printf("  c_pou X          =    changement consigne volet poumon à X.\r\n");
    serial_port->printf("  c_fui X          =    changement consigne volet fuite à X.\r\n");
    serial_port->printf("  calib_p          =    calibration à 0 du volet poumon.\r\n");
    serial_port->printf("  calib_f          =    calibration à 0 du volet fuite.\r\n");
    serial_port->printf("  secu             =    mise des volets en mode sécu.\r\n");
    serial_port->printf("  check_F          =    sortie des valeurs 0 moteurs et ARNSRS_ID enregistrées.\r\n");
    */
    
    serial_port->printf("  COMMANDES CAPTEURS\r\n\r\n");
    serial_port->printf("  Head_ID X        =    Numérote le numéro X d'identification de la sensor Head dans l'eeprom.\r\n");
    serial_port->printf("  O2_1_ID X        =    Numérote le numéro X d'identification de la cellule O2 1 dans l'eeprom.\r\n");
    serial_port->printf("  O2_2_ID X        =    Numérote le numéro X d'identification de la cellule O2 2 dans l'eeprom.\r\n");
    serial_port->printf("  CO2_ID X         =    Numérote le numéro X d'identification du capteur CO2 dans l'eeprom.\r\n");
    //serial_port->printf("  check_E          =    sortie des valeurs de calibration enregistrées dans l'eeprom.\r\n");
    serial_port->printf("  calib_O2 X       =    calibration des cellules O2 dans l'air avec X itérations.\r\n");
    
    serial_port->printf("  Les commandes pour le Mini-r sont à entrer conformément à la doc. Les plus utilisée :\r\n");
    serial_port->printf("  G                =    calibration du capteur CO2 dans l'air.\r\n");
    serial_port->printf("  K 0              =    arrêt du capteur CO2.\r\n");
    serial_port->printf("  K 1              =    capteur CO2 mode streaming.\r\n");
    serial_port->printf("  K 2              =    capteur CO2 mode spooling.\r\n");
    serial_port->printf("  A X              =    digi filter X. X égal à 32, 64, 128...\r\n");
    serial_port->printf("");
    serial_port->printf("  DFU              =    mise à jour firmware\r\n");
    //serial_port->printf("\r\n");
    fflush(stdout);
}

void UTILS::clean_line_EEPROM(unsigned int eeaddress, int address)
{
    DEEP_DEBUG("  Effacage de la ligne à l'adresse %d de l'eeprom.\r\n", eeaddress);
     
    int size = 64;
    char deleteData[] = {"                                                                "};
    
    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB
 
    for (int i = 0; i < size; i++) {
        i2cBuffer[i + 2] = deleteData[i];
    }
 
    int result = I2C_EEPROM.write(address, i2cBuffer, size + 2, false);
    wait_ms(6);
    
    DEEP_DEBUG("  Ligne à l'adresse %d de l'eeprom effacée.\r\n", eeaddress);
}

//Max 63 bit en écriture
void UTILS::write_EEPROM(char *data, unsigned int eeaddress, int address)
{   
    //Nettoyage de la ligne ou on va stocker la nouvelle data
    clean_line_EEPROM(eeaddress);
    
    // On calcul de la taille de la chaine a enregistrer
    char size = 0;
    do {
        size++;
    } while (data[size]);

    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB

    for (int i = 0; i < size; i++) {
        i2cBuffer[i + 2] = data[i];
    }

    int res = I2C_EEPROM.write(address, i2cBuffer, size + 2, false);

    wait_ms(6);

    DEEP_DEBUG("  Chaine écrite à l'adresse %d de l'eeprom : %s\r\n", eeaddress , data);
}

char* UTILS::read_EEPROM(unsigned int eeaddress , int address)
{
    //On lit toute la ligne
    int size = 17;
    static char data[17];
    
    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB
 
    // Reset eeprom pointer address
    int result = I2C_EEPROM.write(address, i2cBuffer, 2, false);
    wait_ms(6);
 
    // Read eeprom
    I2C_EEPROM.read(address, data, size);
    wait_ms(6);
    
    DEEP_DEBUG("  Char lu à l'adresse %d de l'eeprom : %s\r\n", eeaddress, &data);
    
    return data;
    }

void UTILS::read_C_EEPROM(char *data, unsigned int eeaddress ,int address)
{
    //On lit toute la ligne
    int size = 64;
    
    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB
 
    // Reset eeprom pointer address
    int result = I2C_EEPROM.write(address, i2cBuffer, 2, false);
    wait_ms(6);
 
    // Read eeprom
    I2C_EEPROM.read(address, data, size);
    wait_ms(6);
    
    DEEP_DEBUG("  Char lu à l'adresse %d de l'eeprom : %s\r\n", eeaddress, data);
}

float UTILS::read_F_EEPROM(unsigned int eeaddress ,int address)
{
    //On lit toute la ligne
    int size = 64;
    char data[64];

    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB

    int result = I2C_EEPROM.write(address, i2cBuffer, 2, false);
    wait_ms(6);

    I2C_EEPROM.read(address, data, size);
    wait_ms(6);

    float result_F = atof(data);
    DEEP_DEBUG("  Float lu à l'adresse %d de l'eeprom : %f\r\n", eeaddress, result_F);
    return result_F;
}


int UTILS::read_I_EEPROM(unsigned int eeaddress ,int address)
{
    //On lit toute la ligne
    int size = 64;
    char data[64];

    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB

    int result = I2C_EEPROM.write(address, i2cBuffer, 2, false);
    wait_ms(6);

    I2C_EEPROM.read(address, data, size);
    wait_ms(6);

    int result_I = atoi(data);
    DEEP_DEBUG("  Int lu à l'adresse %d l'eeprom : %d\r\n", eeaddress, result_I);
    return result_I;
}

void UTILS::clean_EEPROM(int address)
{
    DEBUG("  Nettoyage total de l'Eeprom (64 colonnes, 4096 lignes).\r\n");
    int i;
    int pointer;
    char deleteData[] = {"                                                                "};
    for (i = 0; i < 4096; i++) {
        pointer = 64 * i;
        clean_line_EEPROM(pointer, address);
    }
    DEBUG("Eeprom néttoyée.\r\n");
}

void UTILS::DFU()
{
DEEP_DEBUG("  mode DFU utils \r\n\r\n");

DEEP_DEBUG("  mode DFU deadbeef \r\n\r\n");
wait(1);



void (*SysMemBootJump)(void);

/**
* Step: Set system memory address.
*
* For STM32F446, system memory is on 0x1FFF 0000
* For other families, check AN2606 document table 110 with descriptions of memory addresses
*/
volatile uint32_t addr = 0x1FFF0000;


/**
* Step: Disable RCC, set it to default (after reset) settings
* Internal clock, no PLL, etc.
*/
HAL_RCC_DeInit();
DEEP_DEBUG("  mode DFU rcc deinit \r\n\r\n");
wait(1);

__HAL_RCC_SYSCFG_CLK_ENABLE();
DEEP_DEBUG("  mode DFU clk enable \r\n\r\n");
wait(1);

/**
* Step: Disable systick timer and reset it to default values
*/
SysTick->CTRL = 0;
SysTick->LOAD = 0;
SysTick->VAL = 0;


/**
* Step: Disable all interrupts
*/
__disable_irq();
DEEP_DEBUG("  mode DFU irq disable \r\n\r\n");
wait(1);

__DSB();

/**
* Step: Remap system memory to address 0x0000 0000 in address space
* For each family registers may be different.
* Check reference manual for each family.
*
* For STM32F4xx, MEMRMP register in SYSCFG is used (bits[1:0])
* For STM32F0xx, CFGR1 register in SYSCFG is used (bits[1:0])
* For others, check family reference manual
*/
//SYSCFG->MEMRMP = 1;

__HAL_SYSCFG_REMAPMEMORY_SYSTEMFLASH(); //Call HAL macro to do this for you

DEEP_DEBUG("  mode DFU remap \r\n\r\n");
wait(1);

/**
* Step: Set jump memory location for system memory
* Use address with 4 bytes offset which specifies jump location where program starts
*/


/* Remap is not visible at once. Execute some unrelated command! */
__DSB();
__ISB();

 


SysMemBootJump = (void (*)(void)) (*((uint32_t *)(addr + 4)));

DEEP_DEBUG("  mode DFU jump \r\n\r\n");
wait(1);


/**
* Step: Set main stack pointer.
* This step must be done last otherwise local variables in this function
* don't have proper value since stack pointer is located on different position
*
* Set direct address location which specifies stack pointer in SRAM location
*/
__set_MSP(*(uint32_t *)addr);

DEEP_DEBUG("  mode DFU set msp \r\n\r\n");
wait(1);

/**
* Step: Actually call our function to jump to set location
* This will start system memory execution
*/

SysMemBootJump();

/**
* Step: Connect USB<->UART converter to dedicated USART pins and test
* and test with bootloader works with STM32 Flash Loader Demonstrator software
*/

while (1);


}