#include "mbed.h"
#include "Encoder.h"
#include "SDFileSystem.h"
#include "motordriver.h"

#define SAMPLETIME 0.001
 
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board

Serial pc(USBTX, USBRX); // tx, rx

Encoder Enc(p21, p22, 12, 0.0001, 0.001);
Motor motor(p25 , p23 , p24 , 10000);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Ticker timer;
FILE* fp;

double Velocity[1000] = { 0 };
double Time[1000] = { 0 };

double t = 0.0;

int n = 0;

void SDwrite() {
    double velocity = -Enc.getVelocity();
    
    Velocity[n] = velocity;
    Time[n] = t;
    
    n += 1;
    t += SAMPLETIME;
}

int main() {
    
    pc.baud(115200);
    
    led2 = 1;   
    fp = fopen("/sd/motor.csv", "w");
    if(fp == NULL) {
        pc.printf("Could not open file for write\n");
    }
    
    timer.attach(&SDwrite, SAMPLETIME);
    
    motor.rotate(1.0);
    
    while(1) {
        led1 = !led1;
        pc.printf("Velocity: %5.2f [rad/s]\n\r", -Enc.getVelocity());
        wait(0.0001);
        if(t > 0.9) break;
    }
    timer.detach();
    
    motor.rotate(0.0);
    led2 = 0;
    led1 = 0;
    
    for( int i = 0; i < n; i++) {
        fprintf(fp,"%f,%f\n",Time[i],Velocity[i]);
    }
    
    
    fclose(fp); 

}
