#include "mbed.h"
#include "PCF2129AT.h"

#define mC 261.626
#define mD 293.665
#define mE 329.628
#define mF 349.228
#define mG 391.995
#define mA 440.000
#define mB 493.883


Ticker flipper;          // 割り込み設定 
I2C i2c(p28,p27);        // sda, scl
//Serial pc(USBTX, USBRX); // tx, rx
DigitalOut myled(LED1);

//PwmOut sp1(p26);

char cmd[32];
char i;
dt_dat dt;                          // 日時構造体の変数設定





DigitalIn sw1(p16);
DigitalIn sw2(p15);
DigitalIn sw3(p14);
//DigitalIn sw4(p30);
DigitalIn sw4(p29);
DigitalIn swK(p18);
DigitalIn swT(p19);
DigitalIn swM(p20);
DigitalIn M_in(p12);

PwmOut belled(p26);

DigitalIn photo(p17);
DigitalOut moledA(p33);
//DigitalOut moledB(p29);

//7セグ表示 (OSL 40562)

#include "mbed.h"
#include "SevenSegLed.h"
 //                     common type (0:anode common 1:cathode common)
 //                     | 
 //                     |  display mode (0:smooth 1:hard)
 //                     |  |
 //                     |  |    segA segB segC segD segE segF segG segP com1 com2 com3 com4 (com5,com6,com7,com8 = NC)                          
 //                     |  |    |    |    |    |    |    |    |    |    |    |    |    | 
SevenSegLed sevenSegLed(1, 1,   p11,  p10,  p9,  p8,  p7,  p6, p5, p4, p22, p23, p24, p25);   // OSL40562-LR


//================================
// display buffer
//================================
//                   com1
//                   |  com2
//                   |  |  com3
//                   |  |  |  com4
//                   |  |  |  |
uint8_t D_7seg[4] = {0, 0, 0, 0};   // 0x0 to 0x9 = "0" to "9" ,0xA to 0xF = "A" to "F", 0x10 = extinction
uint8_t D_dot[4]  = {0, 1, 0, 0};   // 0:extinction  1: light


//==============================
// Variable counter & work
//==============================
uint8_t count = 0;      // free run counter (0x00 to 0xFF overflow to 0x00)
uint8_t work;








 
void set_ch(char sel)
{    // PCA9541のサンプル
        // MST_0側の自分にスレーブ側の制御権を得る場合
    cmd[0] = 1;                     // PCA9541 コマンドコード Cont Reg
    i2c.write( 0xe2, cmd, 1);       // Cont Regを指定
    i2c.read( 0xe2, cmd, 1);        // Cont Regを読込み
    wait(0.1);                      // 0.1s待つ
    switch(cmd[0] & 0xf)
    {
    case 0:                         // bus off, has control
    case 1:                         // bus off, no control
    case 5:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 4;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 2:                         // bus off, no control
    case 3:                         // bus off, has control
    case 6:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 5;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 9:                         // bus on, no control
    case 0xc:                       // bus on, no control
    case 0xd:                       // bus off, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 0;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 0xa:                       // bus on, no control
    case 0xe:                       // bus off, no control
    case 0xf:                       // bus on, has control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 1;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    default:
        break;
    }

    cmd[0] = sel;                   // PCA9546 Cont Reg sel channel enabled
    i2c.write( 0xe8, cmd, 1);       // Send command string
}

void  get_time(dt_dat *dt)      // 日時の取得
{
    cmd[0] = Seconds;                       // 取得はレジスタSecondsから
    i2c.write(PCF2129AT_ADDR, cmd, 1);      // レジスタの設定
    i2c.read(PCF2129AT_ADDR, cmd, 7);       // SecondsからYearsまで取得
    cmd[0] &= 0x7f;                         // 有効なのは下位7ビット
    dt->s = (cmd[0] >> 4) * 10 + (cmd[0] & 0xf);    // BCDの数値化
    cmd[1] &= 0x7f;                         // 有効なのは下位7ビット
    dt->m = (cmd[1] >> 4) * 10 + (cmd[1] & 0xf);    // BCDの数値化
    cmd[2] &= 0x3f;                         // 有効なのは下位6ビット
    dt->h = (cmd[2] >> 4) * 10 + (cmd[2] & 0xf);    // BCDの数値化
    cmd[3] &= 0x3f;                         // 有効なのは下位6ビット
    dt->d = (cmd[3] >> 4) * 10 + (cmd[3] & 0xf);    // BCDの数値化
    dt->wd = (cmd[4] & 0x3);                        // BCDの数値化
    cmd[5] &= 0x1f;                         // 有効なのは下位5ビット
    dt->mm = (cmd[5] >> 4) * 10 + (cmd[5] & 0xf);   // BCDの数値化
    dt->y = (cmd[6] >> 4) * 10 + (cmd[6] & 0xf);    // BCDの数値化
}        

void set_time(dt_dat *dt)       // 日時の設定
{
    cmd[0] = Seconds;                       // 設定はレジスタSecondsから
    cmd[1] = ((dt->s / 10) << 4) + (dt->s % 10) + 0x80; // 秒のBCD化
    cmd[2] = ((dt->m / 10) << 4) + (dt->m % 10);        // 分のBCD化
    cmd[3] = ((dt->h / 10) << 4) + (dt->h % 10);        // 時のBCD化
    cmd[4] = ((dt->d / 10) << 4) + (dt->d % 10);        // 日のBCD化
    cmd[6] = ((dt->mm / 10) << 4) + (dt->mm % 10);      // 月のBCD化
    dt->y = dt->y - 2000;       
    cmd[7] = ((dt->y / 10) << 4) + (dt->y % 10);        // 年のBCD化
    i2c.write(PCF2129AT_ADDR, cmd, 8);      // 日時の設定
}


void flip() {
        get_time(&dt);          // 日時の取得
             // 日時の表示
     //   pc.printf("%04d/%02d/%02d %02d:%02d:%02d\r\n", 2000 + dt.y, dt.mm, dt.d, dt.h, dt.m, dt.s);
}


int main ()
{
    i2c.frequency(100000);
  //  pc.printf("PC2129AT Sample Program\r\n");
    
//    float mm[]={mC,mD,mE,mF,mG,mA,mB,mC*2};
//   int i;
    
     //ブザー設定
     belled = 0;
     belled.period(0.020);
     //belled.pulsewidth(0.001);
     
     
     
    set_ch(2);              // PCF2129ATはch1に接続

  // PCF2129AT
    cmd[0] = CLKOUT_ctl;                // CLKOUTレジスタ設定
    cmd[1] = (3 << 6) + 4;              // 温度測定は30s毎、出力周波数は2048Hz
    i2c.write(PCF2129AT_ADDR, cmd, 2);  // CLKOUT設定

    cmd[0] = Aging_offset;              // Aging_offsetレジスタ設定
    cmd[1] = 0x9;                       // -1ppm
    i2c.write(PCF2129AT_ADDR, cmd, 2);  // Aging_offset設定

    dt.y = 2015;                // 年の設定
    dt.mm = 04;                 // 月の設定
    dt.d = 0;                   // 日の設定
    dt.h = 13;                   // 時の設定
    dt.m = 20;                  // 分の設定
    dt.s = 0;                   // 秒の設定
    set_time(&dt);              // 日時の設定
    
    flipper.attach(&flip, 1.0); //時刻の取得




//int swA=0,swB=0,swC =1;

//お金取り出し機能か、時刻設定かのフラグ
//仮決め

//時刻決定用フラグ
//これのon,offで時刻機能を途中でやめる
int TKflag = 0;

int time1,time2,time3,time4;
int Tflag_F=0;

int Mflag_F = 0;

moledA = 0;
//moledB = 0;
//belled = 0;
    while(1)
    {
        /*
        if(dt.h == 14 && dt.m == 21){ //設定時刻の判定
            myled = 1;
            
        for (i=0;i<sizeof(mm);i++) {
            sp1.period(1.0/mm[i]);
            sp1.write(0.5f);
            wait(0.5f);
            sp1.write(0.0f);
        }
            
        }else myled = 0;
        */
        
        
        /*
        work = dt.h / 10;
        D_7seg[0] = swA;
        work = dt.h % 10;
        D_7seg[1] = swB;
        work = dt.s / 10;
        D_7seg[2] = work;
        work = dt.s % 10;
        D_7seg[3] = work ;
        if(sw == 0){
        D_dot[0]  = 1;}
         else {
            D_dot[0] = 0;
            }
            
        D_dot[1]  = 0;
        D_dot[2]  = 0;
        D_dot[3]  = 0;
        
        if(sw == 1 && swC == 0){
            swA ++;
            swC = 1;
            } else if(sw == 0 && swC == 1){
                swB ++;
                swC =0;
                }
                
        
       */
        D_dot[0]  = 0;
        D_dot[1]  = 0;
        D_dot[2]  = 0;
        D_dot[3]  = 0;
        
        belled = 0;
        
    if( swT == 0 && swM == 0  ){
        
        flipper.attach(&flip, 1.0); //時刻の取得
        
        work = dt.h / 10;
        D_7seg[0] = work;
        work = dt.h % 10;
        D_7seg[1] = work;
        work = dt.m / 10;
        D_7seg[2] = work;
        work = dt.m % 10;
        D_7seg[3] = work;
        
        sevenSegLed.SevenSegLed_main(D_7seg, D_dot); 
        
        if(time1 == (dt.h / 10 ) &&
           time2 == (dt.h % 10 ) &&
           time3 == (dt.m / 10 ) &&
           time4 == (dt.m % 10 )) {
               
               D_7seg[0] = 11;
               D_7seg[1] = 11;
               D_7seg[2] = 11;
               D_7seg[3] = 11;
                sevenSegLed.SevenSegLed_main(D_7seg, D_dot); 
               
               belled = 0.5;
               
               while(1){
                   //wait(0.1);
                   if(M_in == 1 ) break;
                   }
               
               while(1) {
                   //wait(0.1);
                   if(M_in == 0 ) break;
                   }
                   
                belled = 0;
                

                
                time1 = 2;
                time2 = 4;
                time3 = 0;
                time4 = 0;                
                
                   
               } 
        
        if(Tflag_F == 0){
              
              work = dt.h / 10;
              D_7seg[0] = work;
              work = dt.h % 10;
              D_7seg[1] = work;
              work = dt.m / 10;
              D_7seg[2] = work;
              work = dt.m % 10;
              D_7seg[3] = work;
               
             time1 = 2;
             time2 = 4;
             time3 = 0;
             time4 = 0;
           }
                   sevenSegLed.SevenSegLed_main(D_7seg, D_dot); 
        wait(1.0);  
       } 
             
       //時刻決定
    if(swT == 1 && swM == 0){
        int tflag = 0;
        
        //初期値
        int nu1,nu2,nu3,nu4;

        
        if(tflag == 0){ nu1=0,nu2=0,nu3=0,nu4=0;}
        
        D_7seg[0] = nu1;
        D_7seg[1] = nu2;
        D_7seg[2] = nu3;
        D_7seg[3] = nu4;
        

        int swflag_t;
       
        sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
       
       //TKflagでbreak
       while(TKflag == 0){
           
           tflag = 1;

           swflag_t = 0;
           
           while(1){
           if(sw4 == 0){
               nu1++;
               swflag_t=1;
               if(nu1 == 3){ nu1=0; }
               while(sw4 == 0){ 
                   wait(0.1); 
                   if(swT == 0){
                     TKflag = 1;
                     break;
                     }
                   }
               }
               //点滅
               if(swflag_t == 0){
               wait(0.1);
               D_7seg[0] = 16;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               wait(0.1);
               }
               if(swT == 0){ TKflag = 1; }
               D_7seg[0] = nu1;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               if(TKflag == 1) break;
               if(swK == 0) break; 
                   }
                   
          while(swK == 0) { wait(0.1); }
          if(TKflag == 1)  break;
          if(swT == 0) TKflag = 1;
          
          swflag_t = 0;
                   
           while(1){
           if(sw3 == 0){
               nu2++;
               swflag_t=1;
               if(nu1 == 2 && nu2 == 4) { nu2 = 0; }
               if(nu2 == 10){ nu2=0; }
               while(sw3 == 0){ 
                 wait(0.1);
                 if(swT == 0){
                   TKflag = 1;
                   break;
                   }
                 }
               }
               if(swflag_t == 0){
               wait(0.1);
               D_7seg[1] = 16;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               wait(0.1);
               }
               if(swT == 0){ TKflag = 1; }
               D_7seg[1] = nu2;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               if(TKflag == 1) break;
               if(swK == 0) break; 
                   }
                   
           while(swK == 0)  { wait(0.1); }
          if(TKflag == 1)  break;
          if(swT == 0) TKflag = 1;
          
          swflag_t = 0;
           
           while(1){
           if(sw2 == 0){
               nu3++;
               swflag_t=1;
               if(nu3 == 6) { nu3 = 0; }        
               while(sw2 == 0){ 
                 wait(0.1);
                 if(swT == 0){
                   TKflag = 1;
                   break;
                   }
                 }
               }
               if(swflag_t == 0){
               wait(0.1);
               D_7seg[2] = 16;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               wait(0.1);
               }
               if(swT == 0){ TKflag = 1; }
               D_7seg[2] = nu3;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               if(TKflag == 1) break;
               if(swK == 0) break;
                   }
                   
           while(swK == 0) { wait(0.1); }
          if(TKflag == 1)  break; 
          if(swT == 0) TKflag = 1;
          
          swflag_t = 0;         
           
           while(1){
           if(sw1 == 0){
               nu4++;
               swflag_t=1;
               if(nu4 == 10) { nu4 = 0; }
               while(sw1 == 0){ wait(0.1); 
                  if(swT == 0){
                   TKflag = 1;
                   break;
                   }
                }
               }
               if(swflag_t == 0){
               wait(0.1);
               D_7seg[3] = 16;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               wait(0.1);
               }
               D_7seg[3] = nu4;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               if(TKflag == 1) break;
               if(swK == 0) break;
                   }
                   
           while(swK == 0) { wait(0.1); }
          if(TKflag == 1)  break;
          if(swT == 0) TKflag = 1;
          
          swflag_t = 0;        
           
            
          }     
          
          TKflag = 0;
          
          Tflag_F=1;
          time1 = nu1;
          time2 = nu2;
          time3 = nu3;
          time4 = nu4;
          
            
       }
       
    //お金取り出し
    if(swM == 1 && swT == 0){   
    
        
        int tori=0;
        
        D_dot[0]  = 0;
        D_dot[1]  = 0;
        D_dot[2]  = 0;
        D_dot[3]  = 0;
       
       int co1=0,co2=0,co3=0,co4=0;
 
       co4 =  dt.s % 10; 
             
       int  swCo1=0,swCo2=0,swCo3=0;

       
       
       while(tori == 0){
       
       

       
       
       if(sw3 == 1 && swCo3 == 0){
           co3++;
           if(co3 == 10)  {co3 =0 ;}
           } else {
               swCo3 = 1;
               }
 
       
       
       if(sw2 == 1  && swCo2 == 0){
           co2++;
           if(co2 == 10)  {co2 =0 ;}
           } else {
               swCo2 = 1;
               }
        
        if(sw1 == 1  && swCo1 == 0){
           co1++;
           if(co1 == 10)  {co1 =0 ;}
           } else {
               swCo1 = 1;
               }
               


        
 
               
        if(swCo3 == 1 && swCo2 == 1 && swCo1 == 1 ){
            if(co1 == co2 && co2 == co3 && co3 == co4){
                
                tori = 1;
                    while(sw1 == 0 || sw2 == 0 || sw3 == 0){
                     wait(0.1);
                     Mflag_F = 1;
                     }
                
                } else {
                 swCo3 = 0;
                 swCo2 = 0;
                 swCo1 = 0;
                 co1 = 0;
                 co2 = 0;
                 co3 = 0;
                 while(sw1 == 0 || sw2 == 0 || sw3 == 0){
                     wait(0.1);
                     }
                 }
            }
            
            
       D_7seg[0] = co4;
       D_7seg[1] = co3;
       D_7seg[2] = co2;
       D_7seg[3] = co1;  
         
       sevenSegLed.SevenSegLed_main(D_7seg, D_dot);  
       wait(0.1);
       
       if( swM == 0 ) break;       
       if(tori == 1) break;
       
       

       }
       
       
       if(Mflag_F == 1){
           belled = 0.5;
           wait(0.5);
           belled = 0;
           
       moledA = 1;
       
       while(1){
           if(photo == 1 ){
               moledA = 0;
               //wait(0.1);
               break;
               }
               //wait(0.1);
               }
        /*
        while(photo == 1){
            wait(0.1);
            }
        */
        wait(0.1);
        
        /*
        while(1){
            if(swK == 0){
                moledB = 1;
                } else {
                    moledB = 0;
                    }
            if(swM == 0) break;
            wait(0.1);
            }
            */
            
            while(1){
                if(swM == 0) break;
                wait(0.1);
                }
                
            
            //moledB = 0;
        
            }
       
       
        Mflag_F = 0;
        wait(0.1);
        }
        
        
    if(swT == 1 && swM == 1 ) {
        int tflag_d = 0;
        
        //初期値
        int nu1_d,nu2_d,nu3_d,nu4_d;

        
        if(tflag_d == 0){ nu1_d=0,nu2_d=0,nu3_d=0,nu4_d=0;}
        
        D_7seg[0] = nu1_d;
        D_7seg[1] = nu2_d;
        D_7seg[2] = nu3_d;
        D_7seg[3] = nu4_d;
        

        int swflag_t_d;
        
        int TKflag_d = 0;
       
        sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
       
       //TKflagでbreak
       while(TKflag_d == 0){
           
           tflag_d = 1;

           swflag_t_d = 0;
           
           while(1){
           if(sw4 == 0){
               nu1_d++;
               swflag_t_d=1;
               if(nu1_d == 3){ nu1_d=0; }
               while(sw4 == 0){ 
                   wait(0.1); 
                   if(swT == 0){
                     TKflag_d = 1;
                     break;
                     }
                   }
               }
               //点滅
               if(swflag_t_d == 0){
               wait(0.1);
               D_7seg[0] = 16;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               wait(0.1);
               }
               if(swT == 0){ TKflag_d = 1; }
               D_7seg[0] = nu1_d;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               if(TKflag_d == 1) break;
               if(swK == 0) break; 
                   }
                   
          while(swK == 0) { wait(0.1); }
          if(TKflag_d == 1)  break;
          if(swT == 0) TKflag_d = 1;
          
          swflag_t_d = 0;
                   
           while(1){
           if(sw3 == 0){
               nu2_d++;
               swflag_t_d=1;
               if(nu1_d == 2 && nu2_d == 4) { nu2_d = 0; }
               if(nu2_d == 10){ nu2_d=0; }
               while(sw3 == 0){ 
                 wait(0.1);
                 if(swT == 0){
                   TKflag_d = 1;
                   break;
                   }
                 }
               }
               if(swflag_t_d == 0){
               wait(0.1);
               D_7seg[1] = 16;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               wait(0.1);
               }
               if(swT == 0){ TKflag_d = 1; }
               D_7seg[1] = nu2_d;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               if(TKflag_d == 1) break;
               if(swK == 0) break; 
                   }
                   
           while(swK == 0)  { wait(0.1); }
          if(TKflag_d == 1)  break;
          if(swT == 0) TKflag_d = 1;
          
          swflag_t_d = 0;
           
           while(1){
           if(sw2 == 0){
               nu3_d++;
               swflag_t_d=1;
               if(nu3_d == 6) { nu3_d = 0; }        
               while(sw2 == 0){ 
                 wait(0.1);
                 if(swT == 0){
                   TKflag_d = 1;
                   break;
                   }
                 }
               }
               if(swflag_t_d == 0){
               wait(0.1);
               D_7seg[2] = 16;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               wait(0.1);
               }
               if(swT == 0){ TKflag_d = 1; }
               D_7seg[2] = nu3_d;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               if(TKflag_d == 1) break;
               if(swK == 0) break;
                   }
                   
           while(swK == 0) { wait(0.1); }
          if(TKflag_d == 1)  break; 
          if(swT == 0) TKflag_d = 1;
          
          swflag_t_d = 0;         
           
           while(1){
           if(sw1 == 0){
               nu4_d++;
               swflag_t_d=1;
               if(nu4_d == 10) { nu4_d = 0; }
               while(sw1 == 0){ wait(0.1); 
                  if(swT == 0){
                   TKflag_d = 1;
                   break;
                   }
                }
               }
               if(swflag_t_d == 0){
               wait(0.1);
               D_7seg[3] = 16;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               wait(0.1);
               }
               D_7seg[3] = nu4_d;
               sevenSegLed.SevenSegLed_main(D_7seg, D_dot);
               if(TKflag_d == 1) break;
               if(swK == 0) break;
                   }
                   
           while(swK == 0) { wait(0.1); }
          if(TKflag_d == 1)  break;
          if(swT == 0) TKflag_d = 1;
          
          swflag_t_d = 0;        
           
            
          }     
          
          TKflag_d = 0;
          
          while(swM == 1){
              
              }
          
          //Tflag_F=1;
          //time1 = nu1_d;
          //time2 = nu2_d;
          //time3 = nu3_d;
          //time4 = nu4_d;
          
          dt.h = nu1_d * 10 + nu2_d ;
          dt.m = nu3_d * 10 + nu4_d ;
          set_time(&dt);  
    flipper.attach(&flip, 1.0); //時刻の取得
        
        
        
        
        
        
        
        

        
        
            
        }

       // wait(1.0);
    
        
    }
}


