#include "mbed.h"
#include "SDFileSystem.h"
#include "HeptaBattery.h"
#include "HeptaCamera_GPS.h"
#include "Hepta9axis.h"
#include "HeptaTemp.h"

Serial pc(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd");
HeptaBattery battery(p16,p26);
HeptaCamera_GPS cam_gps(p13, p14,p25,p24);
Hepta9axis n_axis(p28,p27,0xD0,0x18);
HeptaTemp temper(p17);

DigitalOut myleds[] = {LED1,LED2,LED3,LED4};;

int rcmd = 0,cmdflag = 0;

void commandget()
{
    rcmd=pc.getc();
    cmdflag = 1;
}
void receive(int *xrcmd, int *xcmdflag)
{
    pc.attach(commandget,Serial::RxIrq);
    *xrcmd = rcmd;
    *xcmdflag = cmdflag;
}

void initialize()
{
    rcmd = 0;
    cmdflag = 0;
}

int main()
{
    pc.baud(9600);
    float bt;
    float temp;
    char str[100];
    float ax,ay,az;
    float gx,gy,gz;
    float mx,my,mz;
    int quality=0,stnum=0,gps_check=0;
    char ns='A',ew='B',aunit='m';
    float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
    int flag = 0;
    while(1) {
        battery.power_saving_mode(&flag,&bt);
        temper.temp_sense(&temp);
        wait(0.5);
        pc.printf("flag = %d, bt = %.2f [V]\r\n",flag,bt);
        if(flag == 1) {
            pc.printf("Low Battery\r\n");
        } else if(temp > 35.0) {
            pc.printf("High Temperaturer\n");
        } else if((flag == 1) & (temp > 35.0)) {
            pc.printf("Low Battery and High Temperaturer\n");
        }
        receive(&rcmd,&cmdflag);
        if (cmdflag == 1) {
            pc.printf("Command Get = %d\r\n",rcmd);
            if (rcmd == 'a') {
                for(int i = 0; i < 10; i++) {
                    pc.printf("Count = %d\r\n",i);
                    wait(1.0);
                }
            }
            if (rcmd == 'b') {
                mkdir("/sd/mydir", 0777);
                FILE *fp = fopen("/sd/mydir/battery.txt","w");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                } else {
                    for(int i = 0; i < 10; i++) {
                        battery.vol(&bt);
                        fprintf(fp,"%f\r\n",bt);
                        wait(1.0);
                    }
                    fclose(fp);
                }
                FILE *fp1 = fopen("/sd/mydir/battery.txt","r");
                if(fp1 == NULL) {
                    error("Could not open file for read\r\n");
                } else {
                    for(int i = 0; i < 10; i++) {
                        fgets(str,100,fp1);
                        puts(str);
                        wait(1.0);
                    }
                    fclose(fp1);
                }
            }//
            if (rcmd == 'c') {
                //pc.printf("Command Get = %d", 'rcmd');
                //get temperture
                temper.temp_sense(&temp);
                //get 9-axis
                n_axis.sen_acc(&ax,&ay,&az);
                n_axis.sen_gyro(&gx,&gy,&gz);
                n_axis.sen_mag(&mx,&my,&mz);    
                //get GPS Data
                cam_gps.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
                
                //Display_All Data
                pc.printf("temp = %.2f[C]\r\n",temp);
                pc.printf("%f,%f,%f\r\n",ax,ay,az);
                pc.printf("%f,%f,%f\r\n",gx,gy,gz);
                pc.printf("%f,%f,%f\r\n",mx,my,mz);
                pc.printf("GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
                wait(0.3);
            }
            if (rcmd == 'd') {
                pc.printf("Camera Snapshot Mode\r\n");
                pc.printf("Hit Any Key To Take Picture\r\n");
                while(!pc.readable()) {}
                cam_gps.Sync();
                cam_gps.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
                cam_gps.test_jpeg_snapshot_picture("/sd/test.jpg");             
            }
            initialize();
        }
    }
}
