#include "mbed.h"
#include "SDFileSystem.h"
#include "HeptaBattery.h"
#include "HeptaTemp.h"

Serial pc(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd");
HeptaBattery battery(p16,p26);
HeptaTemp temper(p17);

DigitalOut myleds[] = {LED1,LED2,LED3,LED4};;

int rcmd = 0,cmdflag = 0;

void commandget()
{
    rcmd=pc.getc();
    cmdflag = 1;
}
void receive(int *xrcmd, int *xcmdflag)
{
    pc.attach(commandget,Serial::RxIrq);
    *xrcmd = rcmd;
    *xcmdflag = cmdflag;
}

void initialize()
{
    rcmd = 0;
    cmdflag = 0;
}

int main()
{
    pc.baud(9600);
    float bt;
    float temp;
    int flag = 0;
    int flagtmp = 0;
    char str[100];
    while(1) {
        battery.vol(&bt);
        temper.temp_sense(&temp);
        if(bt <= 3.5) {
            battery.shut_down_regulator();
            flag = 1;
        } else {
            battery.turn_on_regulator();
            flag = 0;
        }
        if(temp > 30){
            flagtmp = 1;    
        }
        else {
            flagtmp = 0;    
        }
        pc.printf("Vol = %.2f [V]\r\n",bt);
        pc.printf("temp = %f\r\n",temp);
        if(flag == 1) {
            pc.printf("Power saving mode ON\r\n");
        }
        if(flagtmp == 1){
            pc.printf("High Temperture\r\n");    
        }
        if((flag == 1) &(flagtmp == 1)){
            pc.printf("Low Battery and High Temperture\r\n");    
        }
        wait(0.5);
        receive(&rcmd,&cmdflag);
        if (cmdflag == 1) {
            pc.printf("Command Get = %d\r\n",rcmd);
            if (rcmd == 'a') {
                for(int i = 0; i < 10; i++) {
                    pc.printf("Count = %d\r\n",i);
                    wait(1.0);
                }
            }
            if (rcmd == 'b') {
                FILE *fp = fopen("/sd/mydir/test.txt","w");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                }
                for(int i = 0; i <= 10;i++){
                    battery.vol(&bt);
                    pc.printf("Vol = %.2f\r\n",bt);
                    wait(1.0);
                    fprintf(fp,"%f\r\n",bt);
                }
                fclose(fp);
                fp = fopen("/sd/mydir/test.txt","r");
                for(int j = 0; j < 10; j++) {
                    fgets(str,100,fp);
                    puts(str);
                }
                fclose(fp);
    }
            }
            initialize();
        }
    }
