#include "mbed.h"
#include "HeptaBattery.h"

Serial pc(USBTX,USBRX);

DigitalOut myleds[] = {LED1,LED2,LED3,LED4};
HeptaBattery battery(p16, p26);

int rcmd = 0,cmdflag = 0;

void commandget()
{
    rcmd=pc.getc();
    cmdflag = 1;
}
void receive(int *xrcmd, int *xcmdflag)
{
    pc.attach(commandget,Serial::RxIrq);
    *xrcmd = rcmd;
    *xcmdflag = cmdflag;
}

void initialize()
{
    rcmd = 0;
    cmdflag = 0;
}

int main()
{
    pc.baud(9600);
    float bt;
    int flag = 0;
    while(1) {
        battery.vol(&bt);
        if(bt <= 4.0){
            battery.shut_down_regulator();
            flag = 1;    
        }
        else {
            battery.turn_on_regulator();  
            flag = 0;  
        }
        pc.printf("Vol = %.2f[V]\r\n",bt);
        if(flag == 1){
            pc.printf("Power savig mode ON\r\n");  
        }
        wait(0.5);  
        receive(&rcmd,&cmdflag);
        if (cmdflag == 1) {
            if (rcmd == 'a') {
               
               pc.printf("Connected! = %d\n\r",rcmd);
               for(int i = 1;i <= 10;i++){
                    pc.printf("%d\n\r",i);      
                    wait(1.0); 
               }
            }
            initialize();
        }
    }
}