#include "mbed.h"
#include "rtos.h"

typedef struct {
    char *mensaje;
    int  msg_number;
} msg_type;
 
MemoryPool<msg_type, 16> mpool;
Queue<msg_type, 16> queue;
 
/* Send Thread */
void producer_thread (void const *args) {
    uint32_t i = 0;
    int status;
    while (true) {
        i++; // fake data update
        msg_type *message = mpool.alloc();
        message->mensaje="Hola";
        message->msg_number=i;
        status = queue.put(message,1);
        printf("%d",status);
        printf("Message into queue: %d,%s\n\r", message->msg_number, message->mensaje);
        Thread::wait(500);
    }
}
 
int main (void) {
    Thread thread(producer_thread);
    int msg_count=0;
    while (true) {
        osEvent evt = queue.get();
        if (evt.status == osEventMessage) {
            msg_count++;
            msg_type *message = (msg_type*)evt.value.p;
            printf("Message out of queue : %d,%s\n\r", message->msg_number, message->mensaje);
            mpool.free(message);
            Thread::wait(1100);
        }
    }
}
 
