#ifndef MOTOR_H
#define MOTOR_H

#include "mbed.h"
#include "QEI.h"
#include "iostream"
#include "cmath"
class Motor {
  private:
    float angle ;    // angle of the motor in degrees
    float frequency ;
    float safety_angle; //safety angle in degrees
    float low_PWM;
    QEI _Encoder;
    DigitalOut _direction;
    PwmOut _PWM;
    int POS;
    int initial_angle;
    float Kp , Ki , Kd ;
    
    void set_period(float);
    double Control_PID(float);
    
  public:
    Motor();
    Motor(PinName , PinName , PinName , PinName , float ,  float , float , int , int , float , float , float);
    
    
    float Control_angle(float);

    
    float set_angle();               //needs to be updated 
    float get_angle();
    
};

#endif