#include "EMG.h"
// This is a class to set different emg sensors it gets the raw emg as input and returns the filterd envelope of the signal

EMG::EMG(PinName data) : _data(data) , MainsReject(0.940809296, -1.525271192, 0.940809296, 1.000000000, -1.525271192, 0.881618592) ,  // set the coeficients of all filters used in the code 
                                        Low_pass( 0.145323884, 0.290647768, 0.145323884, 1.000000000, -0.671029091, 0.252324626)  ,   // all of the filters are objects of the class BiQuad.h 
                                        HiPass(0.914969144, -1.829938288, 0.914969144, 1.000000000, -1.822694925, 0.837181651) ,      
                                        LoPass( 0.003621682, 0.007243363, 0.003621682, 1.000000000, -1.822694925, 0.837181651)
{
    cntr = 0;
    
}

    
double EMG::get_noise(){            // remove noise from the system (noise is conciderd 80Hz+)

    return Low_pass.step(_data);
}

double EMG::get_notch(double data){ // remove 50Hz peak dew to all electrical network apliances
    
    return MainsReject.step(data);
    
}
     
    
double EMG::get_DC(double data){   // remove DC offset from the signal (High pass filter above 10Hz)
    
    return HiPass.step(data);
    
}
    
    
double EMG::get_absolute(double data){  //get the absolute value of the signal
    
    return fabs(data);
    
}
    
    
double EMG::get_envelope(double data){  // return the envelope of the signal (low pass filter at 5Hz)
    
    return LoPass.step(data);
}
    
double EMG::filter(){                   // Aply all filters and absolute in series in order to get envelope of the EMG signal

    if(cntr<=500)
    {
        cntr++;
        return 0;
    }
    
    else
    {
        return get_envelope(get_absolute(get_DC(get_notch(get_noise()))));
        
    }
    
}

double EMG::get_data(){
    
    return _data;
}



