#include "mbed.h"
#include "rtos.h"
#include "nsdl_support.h"
#include "register_upd_trigger.h"

#define REGISTER_UPD_TRIGGER_ID     "1/0/8"

extern char endpoint_name[16];
extern uint8_t ep_type[];
extern uint8_t lifetime_ptr[];
extern Serial pc;

/* Only POST and PUT method allowed */
static uint8_t register_upd_trigger_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    strcpy((char*) ep_type, "mbed_lpc1768_appboard");
    strcpy((char*) lifetime_ptr, "60");
    pc.printf("Register Update Trigger callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_POST)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    
        sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
        endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
        
        sn_nsdl_update_registration(endpoint_ptr);
    }
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {

        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
        sn_nsdl_send_coap_message(address, coap_res_ptr);

        sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
        endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, (uint8_t*)ep_type, (uint8_t*)lifetime_ptr);
        
        sn_nsdl_update_registration(endpoint_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_register_upd_trigger_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, strlen(REGISTER_UPD_TRIGGER_ID), (uint8_t*)REGISTER_UPD_TRIGGER_ID, 0, 0, 0, &register_upd_trigger_resource_cb, (SN_GRS_POST_ALLOWED | SN_GRS_PUT_ALLOWED));
    return 0;
}