// Light resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "light.h"

#define LIGHT_RES_ID    "311/0/5851"

extern Serial pc;
static PwmOut led2(LED2);
static PwmOut led3(LED3);


/* Only GET and PUT method allowed */
static uint8_t light_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    static float led_dimm = 0;
    int led_state = 0;
    char led_dimm_temp[4];

    pc.printf("light callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        led_state = led_dimm * 100;
        sprintf(led_dimm_temp, "%d", led_state);

        coap_res_ptr->payload_len = strlen(led_dimm_temp);
        coap_res_ptr->payload_ptr = (uint8_t*)led_dimm_temp;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {
        memcpy(led_dimm_temp, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);

        led_dimm_temp[received_coap_ptr->payload_len] = '\0';

        led_dimm = atof(led_dimm_temp);
        led_dimm = led_dimm/100;

        led2.write(led_dimm);
        led3.write(led_dimm);

        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_light_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(LIGHT_RES_ID)-1, (uint8_t*)LIGHT_RES_ID, 0, 0, 0, &light_resource_cb, (SN_GRS_GET_ALLOWED | SN_GRS_PUT_ALLOWED));
    return 0;
}