// Firmware status resource implementation

#include "mbed.h"
#include "rtos.h"
#include "LM75B.h"
#include "nsdl_support.h"
#include "firmware_status.h"
#include "firmware_result.h"

#define FIRMWARE_UPD_STATUS_RES_ID    "5/0/2"

extern Serial pc;
extern "C" void mbed_reset();

/**
 * Cleanup all bin files.
 */
int cleanupAllBinFiles(void) {
    struct dirent *p;
    DIR *dir = opendir("/local");
    if (dir == NULL) {
        return -1;
    }
    while ((p = readdir(dir)) != NULL) {
        char *str = p->d_name;
 
        if ((strstr(str, ".bin") != NULL) || (strstr(str, ".BIN") != NULL)) {
            char buf[BUFSIZ];
            snprintf(buf, sizeof(buf) - 1, "/local/%s", str);
            if (remove(buf) == 0) {
                pc.printf("INFO: Deleted '%s'.\r\n", buf);
            } else {
                pc.printf("ERR : Delete '%s' failed.\r\n", buf);
            }
        }
    }
    closedir(dir);
    return 0;
}

/** fcopy: Copies a file
 *            Checks to ensure destination file was created.
 *            Returns -1 = error; 0 = success
 */
int fcopy (const char *src, const char *dst) { 
    FILE *fpsrc = fopen(src, "r");
    
    if (fpsrc == NULL)
        return 0;
    
    FILE *fpdst = fopen(dst, "w");

    if (fpdst == NULL)
        return 0;

    int ch = fgetc(fpsrc);
    while (ch != EOF) {
        fputc(ch, fpdst);  
        ch = fgetc(fpsrc);   
    }
    fclose(fpsrc);  
    fclose(fpdst);   
    int retval = 0;
    fpdst = fopen(dst, "r");
    if (fpdst == NULL) {
        retval = 0;
    } else {
        fclose(fpdst); 
        retval = 1;
    }
    return retval;
}

/* Only GET, POST method allowed */
static uint8_t firmware_resource_status_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    char firmware_upd_status[16];

    pc.printf("firmware status callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_POST)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
        sn_nsdl_send_coap_message(address, coap_res_ptr);
        wait(2);
        FILE *fpsrc = fopen("/local/OUT.B__", "r");
    
        if (fpsrc == NULL)
        { 
            pc.printf("Tmp file not found...\r\n");
            setResult(7);
            send_firmware_result_observation(7);            
            sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
            return 0;
        }

        if (cleanupAllBinFiles() == -1)
        {
            pc.printf("Cleaning files failed...\r\n");
            setResult(2);
            send_firmware_result_observation(2);            
            sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
            return 0;
        }
        
        pc.printf("Copying NEW_FW...\r\n");
        if (fcopy("/local/OUT.B__","/local/NEW_FW.BIN") == 0)
        {
            setResult(2);
            send_firmware_result_observation(2);
            sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
            return 0;
        }
        pc.printf("Deleting tmp file...\r\n");
        if (remove("/local/out.b__") != 0)
        {
            /*setResult(0);
            send_firmware_result_observation(0);
            sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
            return 0;*/
        }
        pc.printf("Resetting...\r\n");
        wait(3);
        setResult(1);
        mbed_reset();
        
    }

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);
  
        sprintf(firmware_upd_status, "%d", 1);

        coap_res_ptr->payload_len = strlen(firmware_upd_status);
        coap_res_ptr->payload_ptr = (uint8_t*)firmware_upd_status;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_firmware_status_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(FIRMWARE_UPD_STATUS_RES_ID)-1, (uint8_t*) FIRMWARE_UPD_STATUS_RES_ID, 0, 0, 0, &firmware_resource_status_cb, SN_GRS_GET_ALLOWED | SN_GRS_POST_ALLOWED);
    return 0;
}


