// Firmware result resource implementation

#include "mbed.h"
#include "rtos.h"
#include "LM75B.h"
#include "nsdl_support.h"
#include "firmware_result.h"

#define FIRMWARE_UPD_RESULT_RES_ID    "5/0/5"

static uint8_t obs_number = 0;
static uint8_t *obs_token_ptr = NULL;
static uint8_t obs_token_len = 0;
static char temp_val[1];

int result = 1;

extern Serial pc;

int setResult(int presult)
{
    result = presult;
    return result;
}

/* Only GET method allowed */
static uint8_t firmware_resource_result_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    char firmware_upd_result[16];

    pc.printf("firmware result callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);
  
        sprintf(firmware_upd_result, "%d", result);

        coap_res_ptr->payload_len = strlen(firmware_upd_result);
        coap_res_ptr->payload_ptr = (uint8_t*)firmware_upd_result;
    }

    if(received_coap_ptr->token_ptr)
    {
        pc.printf("Token included\r\n");
        if(obs_token_ptr)
        {
            free(obs_token_ptr);
            obs_token_ptr = 0;
        }
        obs_token_ptr = (uint8_t*)malloc(received_coap_ptr->token_len);
        if(obs_token_ptr)
        {
            memcpy(obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            obs_token_len = received_coap_ptr->token_len;
        }
    }

    if(received_coap_ptr->options_list_ptr->observe)
    {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &obs_number;
        coap_res_ptr->options_list_ptr->observe_len = 1;
        obs_number++;
    }

    sn_nsdl_send_coap_message(address, coap_res_ptr);

    coap_res_ptr->options_list_ptr->observe_ptr = 0;
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}


int send_firmware_result_observation(int value)
{
    sprintf(temp_val,"%d" ,value);
    obs_number++;
    if (obs_token_ptr != NULL)
    {
        if(sn_nsdl_send_observation_notification(obs_token_ptr, obs_token_len, (uint8_t*)temp_val, 1, &obs_number, 1, COAP_MSG_TYPE_NON_CONFIRMABLE, 0) == 0)
            pc.printf("Observation firmware result sending failed\r\n");
        else
            pc.printf("Observation, firmware result = %s observer number: %d\r\n", temp_val, obs_number);
    }
    else
        pc.printf("Observation firmware result sending failed: null pointer\r\n");    
    return 0;
}

int create_firmware_result_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(FIRMWARE_UPD_RESULT_RES_ID)-1, (uint8_t*) FIRMWARE_UPD_RESULT_RES_ID, 0, 0, 0, &firmware_resource_result_cb, SN_GRS_GET_ALLOWED | SN_GRS_POST_ALLOWED);
    return 0;
}

