// Light resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "EthernetInterface.h"
#include "firmware.h"
#include "firmware_status.h"
#include "firmware_result.h"
#include "HTTPClient.h"
#include "C12832_lcd.h"

#define FIRMWARE_WRITE_RES_ID    "5/0/1"
//5/0/1 should be used instead

static C12832_LCD lcd;
extern Serial pc;
extern "C" void mbed_reset();

LocalFileSystem local("local");
HTTPClient client;

char *remove_ext(char *dst, const char *filename) {
    size_t len = strlen(filename);
    memcpy(dst, filename, len-3);
    dst[len - 3] = 0;
    return dst;
}

/* Only PUT method allowed */
static uint8_t firmware_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    pc.printf("Firmware updating\r\n");
    lcd.locate(0,0);
    lcd.printf("Firmware Upgrade...\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {
        setResult(0);
        pc.printf("Firmware URL length: %d\r\n",received_coap_ptr->payload_len);
        char firmware_url[200];
        memcpy(firmware_url, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);
        firmware_url[received_coap_ptr->payload_len]='\0';

        pc.printf("Firmware URL: %s\r\n",firmware_url);
        lcd.locate(0,11);
        lcd.printf("Downloading new Firmware...\n");
        
        HTTPFile file("/local/out.b__");
        pc.printf("INFO: Getting from URL '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");

        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
        sn_nsdl_send_coap_message(address, coap_res_ptr);

        int r = client.get(firmware_url, &file);
        if (r != HTTP_OK) {
            if (r == HTTP_PARSE)
                pc.printf("ERR Parse URL: Fetch '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");
            else if (r == HTTP_DNS)
                pc.printf("ERR DNS: Fetch '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");
            else if (r == HTTP_NOTFOUND)
                pc.printf("ERR 404 Not Found: Fetch '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");
            else if (r == HTTP_REFUSED)
                pc.printf("ERR 403 Refused: Fetch '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");
            else if (r == HTTP_ERROR)
                pc.printf("ERR Other HTTP Error: Fetch '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");
            else if (r == HTTP_TIMEOUT)
                pc.printf("ERR Timeout: Fetch '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");
            else if (r == HTTP_CONN)
                pc.printf("ERR Connection: Fetch '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");
            else if (r == HTTP_CLOSED)
                pc.printf("ERR Connection Closed: Fetch '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");
            else
                pc.printf("ERR Other Error %d: Fetch '%s' to '%s'.\r\n", r, firmware_url, "/local/out.b__");
            pc.printf("ERR : Cleaning temp file.\r\n");
            remove("/local/out.b__");
            setResult(2);
 //           send_firmware_result_observation(2);
            lcd.locate(0,22);
            lcd.printf("Failed...\n");
            return 0;
        }
        pc.printf("INFO: Fetched '%s' to '%s'.\r\n", firmware_url, "/local/out.b__");
 
        send_firmware_result_observation(1);
        lcd.locate(0,22);
        lcd.printf("Success...\n");
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_firmware_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(FIRMWARE_WRITE_RES_ID)-1, (uint8_t*)FIRMWARE_WRITE_RES_ID, 0, 0, 0, &firmware_resource_cb, SN_GRS_PUT_ALLOWED);
    return 0;
}

