//controller class
class Controller
{

protected:

public:

    int data[3];
    int output;
    int P_Val;
    int I_Val;
    int D_Val;

    Controller(int dummy) {
        output = 0;
        P_Val = 0;
        I_Val = 0;
        D_Val = 0;
        for(int i = 0; i < 3; i++) {
            data[i] = 0;
        }
    }

    void updateData(int val) {
        //first, update the DataReg
        updateDataReg(val);
        //calculate proportional-value
        calculate_P_Val();
        //calculate Integrate-value
        calculate_I_Val();
        //calculate differentiate-value
        calculate_D_Val();
        //calculate output
        calculateOutput();
    }

    int getOutput(void) {
        return output;
    }

    void updateDataReg(int val) {
        data[0] = data[1];
        data[1] = data[2];
        data[2] = val;
    }

    void calculate_P_Val(void) {
        P_Val = data[2]/4;
    }

    void calculate_I_Val(void) {
        //increase the correction if the current value is + (or - ) over a long timespan
        if(data[2] >= 0) {
            I_Val++;
        } else {
            I_Val--;
        }

    }

    void calculate_D_Val(void) {
        //current X-coordinate - last X-coordinate = direction in which the ball is moving
        //example: 3 - 4 = -1
        //ball moved from 4 to 3. its moving in the minus direction.
        //a minus value will get the correction-Value down.
        D_Val = (data[2] - data[1])/3;
    }

    void calculateOutput() {
        output = P_Val + D_Val + I_Val;
    }


};

