DigitalOut LCD_DB4(p5);
DigitalOut LCD_DB5(p6);
DigitalOut LCD_DB6(p7);
DigitalOut LCD_DB7(p8);

DigitalOut LCD_EN(p30);
DigitalOut LCD_RW(p29);
DigitalOut LCD_RS(p28);

unsigned int get_power2(int a)
{
    int i = 0;

    unsigned int power = 1;
    for(i = 0; i < a; i++) {
        power *= 2;
    }
    return power;
}

unsigned int get_bit(char word, int a)
{
    unsigned int s = get_power2(a);

    if((word & s) != 0)
        return(1);
    else
        return(0);
}

void setDB_singleShot(unsigned short x)
{
    /* This hex number is the same as binary 0001 */
    short MASK = 0x01;

    LCD_DB4 = (MASK & x) ? 1 : 0;
    MASK = MASK << 1;
    LCD_DB5 = (MASK & x) ? 1 : 0;
    MASK = MASK << 1;
    LCD_DB6 = (MASK & x) ? 1 : 0;
    MASK = MASK << 1;
    LCD_DB7 = (MASK & x) ? 1 : 0;
}

void EnableImp()
{
    wait(0.02);
    LCD_EN = 1;
    wait(0.02);
    LCD_EN = 0;
    wait(0.02);
}

void FastEnableImp()
{
    wait(0.001);
    LCD_EN = 1;
    wait(0.001);
    LCD_EN = 0;
    wait(0.001);
}

void init()
{
    //SET ALL BITS TO 0
    LCD_RS = 0;
    LCD_RW = 0;
    LCD_EN = 0;

    setDB_singleShot(0x00);    //HEX 0x00 is 0000 in Binary
    EnableImp();
    //DISPLAY IN 4BIT MODE
    LCD_RS = 0;
    LCD_RW = 0;
    setDB_singleShot(0x02);    //HEX 0x02 is 0010 in Binary
    EnableImp();

    setDB_singleShot(0x00);    //HEX 0x00 is 0000 in Binary
    EnableImp();
    //SET FUNCTION
    LCD_RS = 0;
    LCD_RW = 0;
    setDB_singleShot(0x0C);    //HEX 0x0C is 1100 in Binary
    EnableImp();

    setDB_singleShot(0x00);    //HEX 0x00 is 0000 in Binary
    EnableImp();
    //DISPLAY ON
    LCD_RS = 0;
    LCD_RW = 0;
    setDB_singleShot(0x0C);    //HEX 0x0F is 1111 in Binary --> Cursor ON + BLINKING
    EnableImp();               //HEX 0x0C is 1100 in Binary --> Cursor OFF + NO BLINKING

    setDB_singleShot(0x00);    //HEX 0x00 is 0000 in Binary
    EnableImp();
    //DISPLAY CLEAR
    LCD_RS = 0;
    LCD_RW = 0;
    setDB_singleShot(0x01);    //HEX 0x01 is 0001 in Binary
    EnableImp();

    setDB_singleShot(0x00);    //HEX 0x00 is 0000 in Binary
    EnableImp();
    //SET ENTRY MODE
    LCD_RS = 0;
    LCD_RW = 0;
    setDB_singleShot(0x06);    //HEX 0x06 is 0110 in Binary
    EnableImp();


}

void clearDispl()
{
    //DISPLAY CLEAR
    LCD_RS = 0;
    LCD_RW = 0;
    wait(0.001);
    setDB_singleShot(0x00);    //HEX 0x00 is 0000 in Binary
    FastEnableImp();

    setDB_singleShot(0x01);    //HEX 0x01 is 0001 in Binary
    FastEnableImp();
}

void setCursorPos(unsigned short pos)
{
    LCD_RS = 0;
    LCD_RW = 0;
    
    /* This hex number is the same as binary 0001 */
    short MASK = 0x01;

    MASK = MASK << 4;
    LCD_DB4 = (MASK & pos) ? 1 : 0;
    MASK = MASK << 1;
    LCD_DB5 = (MASK & pos) ? 1 : 0;
    MASK = MASK << 1;
    LCD_DB6 = (MASK & pos) ? 1 : 0;
    MASK = MASK << 1;
    LCD_DB7 = 1;
    FastEnableImp();
    
    MASK = 0x01;
    LCD_DB4 = (MASK & pos) ? 1 : 0;
    MASK = MASK << 1;
    LCD_DB5 = (MASK & pos) ? 1 : 0;
    MASK = MASK << 1;
    LCD_DB6 = (MASK & pos) ? 1 : 0;
    MASK = MASK << 1;
    LCD_DB7 = (MASK & pos) ? 1 : 0;
    FastEnableImp();
}

void writeChar(char x)
{
    LCD_RS = 1;
    LCD_RW = 0;

    LCD_DB4 = get_bit(x, 4);
    LCD_DB5 = get_bit(x, 5);
    LCD_DB6 = get_bit(x, 6);
    LCD_DB7 = get_bit(x, 7);
    EnableImp();

    LCD_DB4 = get_bit(x, 0);
    LCD_DB5 = get_bit(x, 1);
    LCD_DB6 = get_bit(x, 2);
    LCD_DB7 = get_bit(x, 3);
    EnableImp();
}

void fastWriteChar(char x)
{
    LCD_RS = 1;
    LCD_RW = 0;

    LCD_DB4 = get_bit(x, 4);
    LCD_DB5 = get_bit(x, 5);
    LCD_DB6 = get_bit(x, 6);
    LCD_DB7 = get_bit(x, 7);
    FastEnableImp();

    LCD_DB4 = get_bit(x, 0);
    LCD_DB5 = get_bit(x, 1);
    LCD_DB6 = get_bit(x, 2);
    LCD_DB7 = get_bit(x, 3);
    FastEnableImp();
}

void writeHex(unsigned short x, unsigned short y)
{
    LCD_RS = 1;
    LCD_RW = 0;

    setDB_singleShot(x);
    EnableImp();

    setDB_singleShot(y);
    EnableImp();
}

void writeString(char str[])
{
    while(*str) {
        writeChar(*str);
        str++;
    }
}

void fastWriteString(char str[])
{
    while(*str) {
        fastWriteChar(*str);
        str++;
    }
}

void writeHex_RS0_RW0(unsigned short x, unsigned short y)
{
    //SET CGRAM Address
    LCD_RS = 0;
    LCD_RW = 0;

    setDB_singleShot(x);
    EnableImp();

    setDB_singleShot(y);
    EnableImp();
}

void writeHex_RS1_RW0(unsigned short x, unsigned short y)
{
    LCD_RS = 1;
    LCD_RW = 0;

    setDB_singleShot(x);
    EnableImp();

    setDB_singleShot(y);
    EnableImp();
}

void write_pixel_character(void)
{

    for(int i = 0; i < 8; i++) {
        //Set the Adress to 0100 0000 to 0100 0111
        writeHex_RS0_RW0(4, i);
        //Write the user specified pixel line
        switch(i) {
            case 0:
                writeHex(0,14);
                break;
            case 1:
                writeHex(0,14);
                break;
            case 2:
                writeHex(0,4);
                break;
            case 3:
                writeHex(1,15);
                break;
            case 4:
                writeHex(0,4);
                break;
            case 5:
                writeHex(0,14);
                break;
            case 6:
                writeHex(0,10);
                break;
            case 7:
                writeHex(0,10);
                break;
            default:
                writeHex(0,0);
                break;
        }
    }

    writeHex(0,0);

    return;
}

