/* This version has the index file and data pages on a  SD card (512Mbyte)
  it does not suffer from the autorun problem when directly writtin to the mbed flash memory
 It makes readings from one solar panel for open and loaded voltages every 'interval' seconds
 Every readingsPerPage a new web page is created and indexed on a readings web page
 Activty is shown by the flashing blue led (0.5s) means it is connected and output via the serial
 over usb port. 
 
 Data is preserved on subsequent power ups by incrementing file number.
 
 PMR   15/9/10 */

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "NTPClient.h"
#include "SDFileSystem.h"


DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

AnalogIn Voltmeter (p20);

//LocalFileSystem fs("webfs");  // this could be any name

SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sclk, cs, name

EthernetNetIf eth;  
HTTPServer svr;
NTPClient ntp;

bool file_exists(const char * filename)
{
    if (FILE * file = fopen(filename, "r"))
    {
        fclose(file);
        return true;
    }
    return false;
}

void update_web(time_t ctTime , char *filename, char *filename2)
 {
 // updates the readings page, filename with new web file, filename2
    FILE *fp;
     char locTime[32];
      char *ftag;
      char tempfile[32];
     fp=NULL;
    strcpy (tempfile,filename2);     // this prevents corruption of filenam2
    strtok(tempfile,"d/");  // strip off /sd/
    ftag=strtok(NULL,"\0");
     fp=fopen (filename, "a");
     if (fp !=NULL)
    {
      time_t seconds = time(NULL);
      strftime(locTime,32,"%d/%b/%Y  %H:%M:%S",localtime(&seconds));
       fprintf(fp, "\n <a href="); fprintf(fp,"%s ",ftag);  fprintf(fp," > readings at %s </a> </br>",locTime);
        fclose(fp);
   }  
 }
 
 char *update_file(char *filename)

  {
  // check for previous and increnment file number if filename exists
   int n ;
    char *ftag;
    char *ext;
    char *fn;
    char filename2[32];
  
  
//    printf(" filename is now0 %s\n",filename);
   while  (file_exists(filename))
   {
   //increment filename
   // strip off extension
     n = 0;
    
    ext=strstr(filename,".");
 //   strcpy(tmp,ext);
 //    printf(" ext %s\n",ext);

    strtok(filename,"d/"); 
// extract text part of filename and moving pointer to extract the numerical part
    ftag=strtok(NULL,"0")+1; fn=strtok(NULL,"\0");
//    printf(" fname %s\n",ftag);
 //atoi ignores spaces but not characters
    n=atoi(fn);
    n=n+1;
 //  printf("fn %i\n",n);
 // re-assemble filename
     strcpy(filename2,"/sd/"); strcpy(fn,"0");
     strcat(filename2,ftag); strcat(filename2,fn);
 //    printf(" filename is now1 %s\n",filename2);
     strcpy(fn,"");
     sprintf(fn,"%d", n );
     strcat(filename2,fn); strcat(filename2,".htm");
 //     printf(" filename is now2 %s\n",filename2);
     strcpy(filename,filename2); 
   }
   
    return(filename);
  }

void createVolts(time_t ctTime, char *filename)
 {
  
    FILE *fp = fopen(filename, "a");  // Open local filename
    // it ignores path and date defaults 1/1/2008 becausse RTC not set
    // if I call ithe localfilesystem www rather than 'local' it writes and is seen when drive is refreshed
    
    fprintf(fp, "<title> Volt meter test page </title>\n");
    fprintf(fp,"<h1>Volts of the day from port 1</h1>");
    fprintf(fp," Voc,            Vld,           time </br>");
//    fprintf(fp, "volts %f V at %s </br>",Voltmeter.read(), ctime(&ctTime));
    fclose(fp);
  
 }
 
 int updateVolts (time_t ctTime , char *filename)
 {
 FILE *fp;
 int ckc,i;
 int avg=10;
 float volts;
  char locTime[32];
 // check not been displayed
  fp=NULL;  ckc =0;
  DigitalOut loadSwitch(p21);
  Timer tm;
  loadSwitch=0;  // load off
  while ( (fp== NULL)  &&  (ckc++ < 20))
     {
       fp=fopen (filename, "a");
     }  
  if (ckc >19)
       {
         return(1);  // if access prevented
       }    
       else
         {
          time_t seconds = time(NULL);
          strftime(locTime,32,"%d-%b-%y  %H:%M:%S",localtime(&seconds));
// output in form of excel .csv
// oc voltage
         volts=0;
         for(i=0; i < avg ; i++) volts= Voltmeter.read();
         volts = volts /avg; 
         fprintf(fp, "%f,",volts); 
// loaded voltage
         tm.start();
         loadSwitch =1;
// after 1 second read the loaded voltage
         volts=0;
         while ( tm.read() < 1.0);
         for(i=0; i < avg; i++) volts= Voltmeter.read();
         volts = volts /avg;       
         fprintf(fp, "%f,%s </br>" ,volts,locTime);
         loadSwitch=0;
         fclose(fp);
          return(0);
          }
    
 }
 
 
 long int loadTime(void)
 {
   time_t ctTime;
  ctTime = time(NULL); 
  char locTime[32]; 
//  printf("Current time is (UTC): %s\n\r", ctime(&ctTime));  

  Host server(IpAddr(), 123, "0.uk.pool.ntp.org");  
  ntp.setTime(server);
    
  ctTime = time(NULL);  
  set_time (ctTime);  // sets local rtc
  time_t seconds = time(NULL);
  strftime(locTime,32, "%I:%M %p\r\n",localtime(&seconds));
  printf("RTC Time is now (UTC): %s\n\r",locTime );   
  return (ctTime);
 }


int main() {

  time_t systemTime;
  Base::add_rpc_class<DigitalOut>();
  char fname[32];
  char *fn;
  int readings =0;
  const int readingsPerPage = 50;
  long int now_sec,last_time;
  const long int interval = 30;  // seconds
 

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
//  FSHandler::mount("/webfs", "/files"); //Mount /wwww path on /files web path  - this has no meaning
  FSHandler::mount("/sd", "/"); //Mount /wwww path on web root path
 
  
//  svr.addHandler<SimpleHandler>("/");  hard code for Hello world 

  
  systemTime=loadTime();  
  
  printf("System is now (UTC): %s\n\r", ctime(&systemTime)); 
  Timer tm;
  tm.start();
  
  
  svr.addHandler<RPCHandler>("/rpc");   // sets up the remote procedure call handler
  svr.addHandler<FSHandler>("/files");//  this does not see the subdirectory
  svr.addHandler<FSHandler>("/"); //Default handler
  svr.bind(80);
  // assemble file name
  // examples sprintf(ts_adj, "%02d", Hours);  // %02d includes leading zero
  //     strncat(ts,ts_adj,2);
   //Listen indefinitely
   printf("Listening...\n\r");
   
   
  strcpy(fname,"/sd/volts00.htm");
  fn = update_file(fname);   // preserve previous data
  strcpy(fname,fn);
  createVolts(systemTime,fname);
  printf(" updated file %s\n\r",fname);
  update_web(systemTime,"/sd/readings.htm",fname);  // log reading file
 readings =0;
 while (true)
 { 
 
  last_time=0; // seconds

   while(readings < readingsPerPage )
   {
    Net::poll();
    systemTime=time(NULL);
    time_t seconds =time(NULL);
    now_sec = seconds;
     if(tm.read()>0.5)
      {
       led1=!led1; //Show that we are alive
         tm.start();
      
       }
    if (now_sec > (last_time + interval))
    {
      if (updateVolts(systemTime,fname)) printf("  %s not updated \n\r", fname); 
          else printf(" reading %i\n\r",readings);
        last_time=now_sec;
        readings++;
      
     }
   }
  fn = update_file(fname);
  strcpy(fname,fn);
  createVolts(systemTime,fname);
  printf(" updated file %s\n\r",fname);
  update_web(systemTime,"/sd/readings.htm",fname);
   readings=0;
  }
  return 0;

}