#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "NTPClient.h"

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

AnalogIn Voltmeter (p20);

LocalFileSystem fs("webfs");  // this could be any name

EthernetNetIf eth;  
HTTPServer svr;
NTPClient ntp;

int updateVolts(time_t ctTime)
 {
    
    FILE *fp = fopen("/webfs/volts.htm", "w");  // Open local filename
    // it ignores path and date defaults 1/1/2008 becausse RTC not set
    // if I call ithe localfilesystem www rather than 'local' it writes and is seen when drive is refreshed
    fprintf(fp, "<title> Volt meter test page </title>\n");
    fprintf(fp,"<h1>Volts of the day from port 1</h1>");
    fprintf(fp, "volts %f V at %s \r\n",Voltmeter.read(), ctime(&ctTime));
    fclose(fp);
    return(0);
 }

 long int loadTime(void)
 {
   time_t ctTime;
  ctTime = time(NULL); 
  char locTime[32]; 
//  printf("Current time is (UTC): %s\n\r", ctime(&ctTime));  

  Host server(IpAddr(), 123, "0.uk.pool.ntp.org");  
  ntp.setTime(server);
    
  ctTime = time(NULL);  
  set_time (ctTime);  // sets local rtc
  time_t seconds = time(NULL);
  strftime(locTime,32, "%I:%M %p\r\n",localtime(&seconds));
  printf("RTC Time is now (UTC): %s\n\r",locTime );   
  return (ctTime);
 }


int main() {

  time_t systemTime;
  Base::add_rpc_class<DigitalOut>();

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
//  FSHandler::mount("/webfs", "/files"); //Mount /wwww path on /files web path  - this has no meaning
  FSHandler::mount("/webfs", "/"); //Mount /wwww path on web root path
 
  
//  svr.addHandler<SimpleHandler>("/");  hard code for Hello world 

  
  systemTime=loadTime();  
  
  printf("System is now (UTC): %s\n\r", ctime(&systemTime)); 
  Timer tm;
  tm.start();
  
  
  svr.addHandler<RPCHandler>("/rpc");   // sets up the remote procedure call handler
  svr.addHandler<FSHandler>("/files");//  this does not see the subdirectory
  svr.addHandler<FSHandler>("/"); //Default handler
  svr.bind(80);
  updateVolts(systemTime);
  printf("Listening...\n\r");
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>0.5)
    {
      led1=!led1; //Show that we are alive
 // writing to this file continually updates the drive as attached as a usb drive to the host and generates errors  so not good
 // and even at 2 second interval the auto play continually brings up windows
  //   updateVolts();
      tm.start();
    }
  }
  
  return 0;

}