
/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following cnditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef DNSREQUEST_H
#define DNSREQUEST_H

#include "if/net/net.h"
//Essentially it is a safe interface to NetDnsRequest

enum DNSRequestErr
{
  __DNS_MIN = -0xFFFF,
  DNS_SETUP, //NetDnsRequest not properly configured
  DNS_IF, //If has problems, does not exist or is not initialized
  DNS_MEM, //Not enough mem
  DNS_INUSE, //If/Port is in use
  DNS_PROCESSING, //Req has not completed
//...
  DNS_OK = 0
};

enum DNSReply
{
  DNS_PRTCL,
  DNS_NOTFOUND, //Hostname is unknown
  DNS_ERROR, //Problem with DNS Service
  //...
  DNS_FOUND,
};

class DNSRequest
{
public:
  DNSRequest();
  ~DNSRequest();
  
  DNSRequestErr resolve(const char* hostname);
  DNSRequestErr resolve(Host* pHost);
  
  class CDummy;
  void setOnReply( void (*pMethod)(DNSReply) );
  template<class T> 
  void setOnReply( T* pItem, void (T::*pMethod)(DNSReply) )
  {
    m_pCbItem = (CDummy*) pItem;
    m_pCbMeth = (void (CDummy::*)(DNSReply)) pMethod;
  }
  
  DNSRequestErr getResult(IpAddr* pIp);
  
  DNSRequestErr close();
  
protected:
  void onNetDnsReply(NetDnsReply r);
  DNSRequestErr checkInst();

private:
  NetDnsRequest* m_pNetDnsRequest;
  
  CDummy* m_pCbItem;
  void (CDummy::*m_pCbMeth)(DNSReply);
  
  void (*m_pCb)(DNSReply);

};

#endif
