#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "NTPClient.h"

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

AnalogIn Voltmeter (p20);

LocalFileSystem fs("webfs");  // this could be any name

EthernetNetIf eth;  
HTTPServer svr;
// NTPClient ntp;

int updateVolts(void)
 {
    FILE *fp = fopen("/webfs/volts.htm", "w");  // Open local filename
    // it ignores path and date defaults 1/1/2008 becausse RTC not set
    // if I call ithe localfilesystem www rather than 'local' it writes and is seen when drive is refreshed
    fprintf(fp, "<title> Volt meter test page </title>\n");
    fprintf(fp,"<h1>Volts of the day from port 1</h1>");
    fprintf(fp, "volts %f V\r\n",Voltmeter.read());
    fclose(fp);
    return(0);
 }

int loadTime(void)
 {
   time_t ctTime;
  ctTime = time(NULL);  
  printf("Current time is (UTC): %s\n\r", ctime(&ctTime));  

  Host server(IpAddr(192.168.1.4), 123, "0.uk.pool.ntp.org");  // fails here
  ntp.setTime(server);
    
  ctTime = time(NULL);  
  
  printf("Time is now (UTC): %s\n\r", ctime(&ctTime)); 
  return 0;
 }


int main() {

    
  Base::add_rpc_class<DigitalOut>();

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
//  FSHandler::mount("/webfs", "/files"); //Mount /wwww path on /files web path  - this has no meaning
  FSHandler::mount("/webfs", "/"); //Mount /wwww path on web root path
 
  
//  svr.addHandler<SimpleHandler>("/");  hard code for Hello world 
svr.addHandler<RPCHandler>("/rpc");   // sets up the remote procedure call handler
// svr.addHandler<FSHandler>("/files");//  this does not see the subdirectory
  svr.addHandler<FSHandler>("/"); //Default handler
  svr.bind(80);
  
  printf("Listening...\n\r");
  
  loadTime();  
  Timer tm;
  tm.start();
  updateVolts();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>2.0)
    {
      led1=!led1; //Show that we are alive
 // writing to this file continually updates the drive as attached as a usb drive to the host and generates errors  so not good
 // and even at 2 second interval the auto play continually brings up windows
  //   updateVolts();
      tm.start();
    }
  }
  
  return 0;

}