#include "mbed.h"
#include "BNO055.h"

#define PI_CHIP_ADDR  (0x42<<1)

Serial pc(USBTX, USBRX);
int baudrate = 115200;

I2C i2c(p28,p27);

BNO055 imu(i2c,p8);

//    dt[0] = BNO055_EULER_H_LSB;
//    _i2c.write(chip_addr, dt, 1, true);
//    _i2c.read(chip_addr, dt, 6, false);

// Delay between i2c register request and reading buffer.
int i2c_delay=1500;    // Any delay less than 2ms between requests and reads results in buffer not being loaded.


void read_i2c(char key[3],int length=4) {
    char buffer[100];
    char check_buffer[length+1];
    i2c.write(PI_CHIP_ADDR,key,1);
    wait_us(i2c_delay);
    i2c.read(PI_CHIP_ADDR,buffer,(length*2)+1);
    int i=0;
    int bad_val=0;
    int a = 0;
    while (i < (length+1)) {
        a = (buffer[length+i]-'0');
        if (a!=-6) {
            printf("%d at %d\r\n",a,(i+length));
            bad_val=1;
            i=9000;
        }
        i+=1;
    }
    i=0;
    while (i<length) {
        a = (buffer[i]-'0');
        if (a==-6) {
            bad_val=1;
            i=9000;
        }
        i+=1;
    }
    sscanf(check_buffer, "%d", &bad_val);
    if (bad_val) {
        printf(" BAD READ: %s\r\n",buffer);
    }
    else {
        printf(" %c: %s\r\n",key[0],buffer);
    }
    wait_us(i2c_delay);
}

int main() {
    pc.baud(baudrate);          // serial baudrate
    i2c.frequency(1000000);     // max RasPi i2c frequency
    uint32_t status=0x0;
    char hea[3];
    hea[0]='h';
    char pit[3];
    pit[0]='p';
    while(1) {
        read_i2c(hea);
        read_i2c(pit);
        status=imu.read_calib_status();
        printf("bno: %x\r\n",status);
        printf("\r\n");
        wait_ms(500);
    }
}
