#ifndef QMC5883L_
#define QMC5883L_
 
#include <mbed.h>
#include <math.h>
 
/**
 * notes:
 * - do not readout faster than the set ODR (currently 200 Hz)
 * - the actual signal magnitude (norm) is sensitive to temperature,
 *   give the unit some time after startup
 * - readMag needs approx 2450 mus
 */
 
#define QMC5883L_ADDRESS 0x1A
 
#define OUT_X_LSB    0x00
#define OUT_X_MSB    0x01
#define OUT_Y_LSB    0x02
#define OUT_Y_MSB    0x03
#define OUT_Z_LSB    0x04
#define OUT_Z_MSB    0x05
#define CONTROL_A    0x09
#define SET_RESET    0x0B
  
class QMC5883L
{
    public:
        QMC5883L(I2C& i2c);
        void readMag();
        float magX();
        float magY();
        float magZ();
 
    private:
        I2C& i2c;
        int16_t m_mag_val[3] = {0, 0, 0};
        float m_scale;
        void init();
        void getMagValue(const uint8_t& OUT_LSB, const uint8_t& OUT_MSB, int16_t& retval);
        bool ReadByte(const uint8_t& reg, uint8_t& data);
        bool WriteByte(const uint8_t& reg, const uint8_t& data);
};
 
#endif /* QMC5883L_ */