#ifndef NEOM9N_THREAD_H
#define NEOM9N_THREAD_H

#include <mbed.h>

#include "Eigen/Dense.h"
#include "ThreadFlag.h"
//#include "data_structs.h"

/**
 * notes:
 * - you need to configure neo-m9n unit according to one note notes. basically flash 20220602_M9N_config_00.txt via u-center and save
 * u-centger: Tools -> Receiver Configuration TransferFile -> GNSS and apply: 20220602_M9N_config_00.txt
MON-VER - 0A 04 DC 00 45 58 54 20 43 4F 52 45 20 34 2E 30 34 20 28 37 66 38 39 66 37 29 00 00 00 00 00 00 00 00 30 30 31 39 30 30 30 30 00 00 52 4F 4D 20 42 41 53 45 20 30 78 31 31 38 42 32 30 36 30 00 00 00 00 00 00 00 00 00 00 00 46 57 56 45 52 3D 53 50 47 20 34 2E 30 34 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 50 52 4F 54 56 45 52 3D 33 32 2E 30 31 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4D 4F 44 3D 4E 45 4F 2D 4D 39 4E 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 47 50 53 3B 47 4C 4F 3B 47 41 4C 3B 42 44 53 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 53 42 41 53 3B 51 5A 53 53 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
CFG-VALGET - 06 8B 44 01 01 00 00 00 01 00 01 10 00 01 01 01 10 00 01 00 04 10 00 02 00 04 10 00 03 00 04 10 00 04 00 04 10 00 09 00 04 10 00 07 00 05 10 01 08 00 05 10 01 09 00 05 10 01 0A 00 05 10 01 0B 00 05 10 01 12 00 05 10 00 13 00 05 10 01 14 00 05 10 01 15 00 05 10 01 16 00 05 10 01 33 00 05 10 01 34 00 05 10 01 12 00 11 10 00 13 00 11 10 00 14 00 11 10 01 15 00 11 10 01 16 00 11 10 01 18 00 11 10 01 19 00 11 10 00 1B 00 11 10 00 25 00 11 10 00 46 00 11 10 01 52 00 11 10 00 53 00 11 10 00 61 00 11 10 00 81 00 11 10 00 82 00 11 10 00 83 00 11 10 00 01 00 22 10 00 02 00 22 10 00 03 00 22 10 00 04 00 22 10 00 01 00 23 10 01 12 00 23 10 00 13 00 23 10 00 21 00 23 10 00 22 00 23 10 00 23 00 23 10 00 24 00 23 10 00 12 00 24 10 00 20 00 24 10 00 30 00 24 10 00 40 00 24 10 00 50 00 24 10 00 01 00 25 10 00 13 00 26 10 00 14 00 26 10 00 17 00 26 10 00 18 00 26 10 00 1A 00 26 10 00 1B 00 26 10 00 01 00 31 10 01 05 00 31 10 01 07 00 31 10 01 0D 00 31 10 01 12 00 31 10 01 18 00 31 10 01
CFG-VALGET - 06 8B 44 01 01 00 40 00 1F 00 31 10 01 20 00 31 10 01 21 00 31 10 01 22 00 31 10 01 24 00 31 10 01 25 00 31 10 01 01 00 33 10 00 02 00 33 10 00 03 00 33 10 00 11 00 33 10 00 01 00 34 10 00 02 00 34 10 00 03 00 34 10 01 04 00 34 10 00 11 00 34 10 00 01 00 35 10 00 02 00 35 10 00 03 00 35 10 00 04 00 35 10 00 02 00 36 10 00 03 00 36 10 01 04 00 36 10 01 05 00 36 10 00 02 00 37 10 00 03 00 37 10 00 05 00 37 10 01 06 00 37 10 00 07 00 37 10 00 07 00 41 10 01 09 00 41 10 01 0A 00 41 10 01 0B 00 41 10 00 0C 00 41 10 01 0D 00 41 10 00 13 00 41 10 00 02 00 51 10 00 03 00 51 10 01 05 00 52 10 01 06 00 52 10 00 07 00 52 10 00 05 00 53 10 01 06 00 53 10 00 07 00 53 10 00 02 00 64 10 00 03 00 64 10 00 04 00 64 10 00 05 00 64 10 00 06 00 64 10 00 07 00 64 10 00 01 00 65 10 01 02 00 65 10 01 03 00 65 10 00 05 00 65 10 00 06 00 65 10 00 07 00 65 10 00 08 00 65 10 00 09 00 65 10 00 19 00 65 10 01 01 00 71 10 01 02 00 71 10 01 04 00 71 10 01 01 00 72 10 01 02 00 72 10 01 01 00 73 10 01
CFG-VALGET - 06 8B 44 01 01 00 80 00 02 00 73 10 01 04 00 73 10 01 01 00 74 10 01 02 00 74 10 01 01 00 75 10 01 02 00 75 10 01 04 00 75 10 01 01 00 76 10 00 02 00 76 10 00 01 00 77 10 01 02 00 77 10 01 04 00 77 10 01 01 00 78 10 01 02 00 78 10 01 01 00 79 10 01 02 00 79 10 01 04 00 79 10 01 01 00 7A 10 01 02 00 7A 10 01 01 00 81 10 00 02 00 81 10 00 03 00 81 10 00 04 00 81 10 00 05 00 81 10 00 01 00 82 10 00 02 00 82 10 00 03 00 82 10 00 04 00 82 10 00 05 00 82 10 00 01 00 83 10 00 02 00 83 10 00 03 00 83 10 00 04 00 83 10 00 05 00 83 10 00 01 00 84 10 00 02 00 84 10 00 03 00 84 10 00 04 00 84 10 00 05 00 84 10 00 01 00 85 10 00 02 00 85 10 00 03 00 85 10 00 04 00 85 10 00 05 00 85 10 00 03 00 93 10 00 04 00 93 10 01 05 00 93 10 00 06 00 93 10 00 11 00 93 10 00 12 00 93 10 00 13 00 93 10 00 15 00 93 10 00 16 00 93 10 00 17 00 93 10 00 21 00 93 10 00 22 00 93 10 00 23 00 93 10 00 24 00 93 10 00 25 00 93 10 00 26 00 93 10 00 01 00 A1 10 00 02 00 A1 10 00 03 00 A1 10 01 01 00 A2 10 00
CFG-VALGET - 06 8B 44 01 01 00 C0 00 02 00 A2 10 00 02 00 A3 10 01 07 00 A3 10 00 08 00 A3 10 00 09 00 A3 10 00 0A 00 A3 10 00 0B 00 A3 10 00 0C 00 A3 10 00 0D 00 A3 10 00 0E 00 A3 10 00 0F 00 A3 10 01 10 00 A3 10 00 11 00 A3 10 01 18 00 A3 10 00 19 00 A3 10 00 29 00 A3 10 00 2C 00 A3 10 00 2E 00 A3 10 01 2F 00 A3 10 00 30 00 A3 10 01 31 00 A3 10 00 32 00 A3 10 01 33 00 A3 10 00 34 00 A3 10 00 35 00 A3 10 00 47 00 A3 10 01 56 00 A3 10 00 58 00 A3 10 00 59 00 A3 10 00 5A 00 A3 10 00 5B 00 A3 10 00 5C 00 A3 10 00 5D 00 A3 10 00 04 00 A5 10 00 02 00 C6 10 00 01 00 C7 10 00 02 00 C7 10 00 08 00 D0 10 00 09 00 D0 10 00 0A 00 D0 10 01 0C 00 D0 10 00 0D 00 D0 10 00 0E 00 D0 10 00 10 00 D0 10 00 11 00 D0 10 00 02 00 DE 10 00 03 00 DE 10 00 04 00 DE 10 00 09 00 F6 10 00 11 00 01 20 00 21 00 01 20 00 31 00 01 20 00 41 00 01 20 00 51 00 01 20 00 61 00 01 20 00 71 00 01 20 00 81 00 01 20 00 91 00 01 20 00 A1 00 01 20 00 B1 00 01 20 00 C1 00 01 20 00 D1 00 01 20 00 E1 00 01 20 00 11 01 01 20 00
CFG-VALGET - 06 8B 44 01 01 00 00 01 21 01 01 20 00 31 01 01 20 00 41 01 01 20 00 51 01 01 20 00 61 01 01 20 00 71 01 01 20 00 81 01 01 20 00 91 01 01 20 00 A1 01 01 20 00 B1 01 01 20 00 C1 01 01 20 00 D1 01 01 20 00 E1 01 01 20 00 0C 00 05 20 00 17 00 05 20 00 23 00 05 20 00 30 00 05 20 01 11 00 11 20 02 1A 00 11 20 12 1C 00 11 20 00 20 00 11 20 64 21 00 11 20 07 22 00 11 20 00 23 00 11 20 00 24 00 11 20 01 26 00 11 20 00 42 00 11 20 02 43 00 11 20 03 44 00 11 20 01 45 00 11 20 01 51 00 11 20 00 A1 00 11 20 03 A2 00 11 20 20 A3 00 11 20 06 A4 00 11 20 05 AA 00 11 20 00 AB 00 11 20 00 C4 00 11 20 3C D5 00 11 20 00 D6 00 11 20 00 03 00 21 20 01 05 00 22 20 00 11 00 22 20 19 12 00 22 20 32 13 00 22 20 19 14 00 22 20 66 21 00 22 20 0A 22 00 22 20 32 31 00 22 20 99 32 00 22 20 4C 11 00 24 20 00 13 00 24 20 00 14 00 24 20 00 38 00 25 20 00 19 00 26 20 00 20 00 26 20 00 05 00 34 20 0A 07 00 34 20 37 21 00 34 20 00 22 00 34 20 02 01 00 41 20 03 02 00 41 20 0F 03 00 41 20 06 04 00 41 20 0A
CFG-VALGET - 06 8B 44 01 01 00 40 01 05 00 41 20 02 06 00 41 20 06 0E 00 41 20 1E 0F 00 41 20 03 10 00 41 20 00 01 00 51 20 84 09 00 51 20 01 02 00 52 20 01 03 00 52 20 00 04 00 52 20 00 08 00 52 20 00 09 00 52 20 01 02 00 53 20 01 03 00 53 20 00 04 00 53 20 00 08 00 53 20 00 09 00 53 20 01 01 00 64 20 32 08 00 64 20 00 09 00 64 20 00 06 00 91 20 00 07 00 91 20 01 08 00 91 20 00 09 00 91 20 00 0A 00 91 20 00 10 00 91 20 00 11 00 91 20 00 12 00 91 20 00 13 00 91 20 00 14 00 91 20 00 15 00 91 20 00 16 00 91 20 00 17 00 91 20 00 18 00 91 20 00 19 00 91 20 00 1A 00 91 20 00 1B 00 91 20 00 1C 00 91 20 00 1D 00 91 20 00 1E 00 91 20 00 24 00 91 20 00 25 00 91 20 00 26 00 91 20 00 27 00 91 20 00 28 00 91 20 00 29 00 91 20 00 2A 00 91 20 00 2B 00 91 20 00 2C 00 91 20 00 2D 00 91 20 00 38 00 91 20 00 39 00 91 20 00 3A 00 91 20 00 3B 00 91 20 00 3C 00 91 20 00 3D 00 91 20 00 3E 00 91 20 00 3F 00 91 20 00 40 00 91 20 00 41 00 91 20 00 42 00 91 20 00 43 00 91 20 00 44 00 91 20 00 45 00 91 20 00
CFG-VALGET - 06 8B 44 01 01 00 80 01 46 00 91 20 00 47 00 91 20 00 48 00 91 20 00 49 00 91 20 00 4A 00 91 20 00 4B 00 91 20 00 4C 00 91 20 00 4D 00 91 20 00 4E 00 91 20 00 4F 00 91 20 00 50 00 91 20 00 51 00 91 20 00 52 00 91 20 00 53 00 91 20 00 54 00 91 20 00 55 00 91 20 00 56 00 91 20 00 57 00 91 20 00 58 00 91 20 00 59 00 91 20 00 5A 00 91 20 00 5B 00 91 20 00 5C 00 91 20 00 5D 00 91 20 00 5E 00 91 20 00 5F 00 91 20 00 60 00 91 20 00 61 00 91 20 00 62 00 91 20 00 63 00 91 20 00 64 00 91 20 00 65 00 91 20 00 66 00 91 20 00 67 00 91 20 00 68 00 91 20 00 69 00 91 20 00 6A 00 91 20 00 6B 00 91 20 00 6C 00 91 20 00 6D 00 91 20 00 6E 00 91 20 00 79 00 91 20 00 7A 00 91 20 00 7B 00 91 20 00 7C 00 91 20 00 7D 00 91 20 00 7E 00 91 20 00 7F 00 91 20 00 80 00 91 20 00 81 00 91 20 00 82 00 91 20 00 83 00 91 20 00 84 00 91 20 00 85 00 91 20 00 86 00 91 20 00 87 00 91 20 00 92 00 91 20 00 93 00 91 20 00 94 00 91 20 00 95 00 91 20 00 96 00 91 20 00 A1 00 91 20 00 A2 00 91 20 00 A3 00 91 20 00
CFG-VALGET - 06 8B 44 01 01 00 C0 01 A4 00 91 20 00 A5 00 91 20 00 A6 00 91 20 00 A7 00 91 20 00 A8 00 91 20 00 A9 00 91 20 00 AA 00 91 20 00 AB 00 91 20 01 AC 00 91 20 00 AD 00 91 20 01 AE 00 91 20 01 AF 00 91 20 01 B0 00 91 20 01 B1 00 91 20 00 B2 00 91 20 01 B3 00 91 20 01 B4 00 91 20 01 B5 00 91 20 00 B6 00 91 20 00 B7 00 91 20 00 B8 00 91 20 00 B9 00 91 20 00 BA 00 91 20 01 BB 00 91 20 00 BC 00 91 20 01 BD 00 91 20 01 BE 00 91 20 01 BF 00 91 20 01 C0 00 91 20 00 C1 00 91 20 01 C2 00 91 20 01 C3 00 91 20 01 C4 00 91 20 01 C5 00 91 20 00 C6 00 91 20 01 C7 00 91 20 01 C8 00 91 20 01 C9 00 91 20 01 CA 00 91 20 00 CB 00 91 20 01 CC 00 91 20 01 CD 00 91 20 01 CE 00 91 20 00 CF 00 91 20 00 D0 00 91 20 00 D1 00 91 20 00 D2 00 91 20 00 D3 00 91 20 00 D4 00 91 20 00 D5 00 91 20 00 D6 00 91 20 00 D7 00 91 20 00 D8 00 91 20 00 D9 00 91 20 00 DA 00 91 20 00 DB 00 91 20 00 DC 00 91 20 00 DD 00 91 20 00 DE 00 91 20 00 DF 00 91 20 00 E0 00 91 20 00 E1 00 91 20 00 E7 00 91 20 00 E8 00 91 20 00
CFG-VALGET - 06 8B 44 01 01 00 00 02 E9 00 91 20 00 EA 00 91 20 00 EB 00 91 20 00 EC 00 91 20 00 ED 00 91 20 00 EE 00 91 20 00 EF 00 91 20 00 F0 00 91 20 00 F1 00 91 20 00 F2 00 91 20 00 F3 00 91 20 00 F4 00 91 20 00 F5 00 91 20 00 F6 00 91 20 00 F7 00 91 20 00 F8 00 91 20 00 F9 00 91 20 00 FA 00 91 20 00 19 01 91 20 00 1A 01 91 20 00 1B 01 91 20 00 1C 01 91 20 00 1D 01 91 20 00 37 01 91 20 00 38 01 91 20 00 39 01 91 20 00 3A 01 91 20 00 3B 01 91 20 00 41 01 91 20 00 42 01 91 20 00 43 01 91 20 00 44 01 91 20 00 45 01 91 20 00 55 01 91 20 00 56 01 91 20 00 57 01 91 20 00 58 01 91 20 00 59 01 91 20 00 5F 01 91 20 00 60 01 91 20 00 61 01 91 20 00 62 01 91 20 00 63 01 91 20 00 78 01 91 20 00 79 01 91 20 00 7A 01 91 20 00 7B 01 91 20 00 7C 01 91 20 00 7D 01 91 20 00 7E 01 91 20 00 7F 01 91 20 00 80 01 91 20 00 81 01 91 20 00 82 01 91 20 00 83 01 91 20 00 84 01 91 20 00 85 01 91 20 00 86 01 91 20 00 87 01 91 20 00 88 01 91 20 00 89 01 91 20 00 8A 01 91 20 00 8B 01 91 20 00 8C 01 91 20 00
CFG-VALGET - 06 8B 44 01 01 00 40 02 8D 01 91 20 00 8E 01 91 20 00 8F 01 91 20 00 90 01 91 20 00 91 01 91 20 00 92 01 91 20 00 93 01 91 20 00 94 01 91 20 00 95 01 91 20 00 96 01 91 20 00 97 01 91 20 00 98 01 91 20 00 99 01 91 20 00 9A 01 91 20 00 9B 01 91 20 00 9C 01 91 20 00 9D 01 91 20 00 9E 01 91 20 00 9F 01 91 20 00 A0 01 91 20 00 A1 01 91 20 00 A2 01 91 20 00 A3 01 91 20 00 A4 01 91 20 00 A5 01 91 20 00 A6 01 91 20 00 A7 01 91 20 00 A8 01 91 20 00 A9 01 91 20 00 AA 01 91 20 00 AB 01 91 20 00 AC 01 91 20 00 AD 01 91 20 00 AE 01 91 20 00 AF 01 91 20 00 B0 01 91 20 00 B1 01 91 20 00 B2 01 91 20 00 B3 01 91 20 00 B4 01 91 20 00 B5 01 91 20 00 B6 01 91 20 00 B7 01 91 20 00 B8 01 91 20 00 B9 01 91 20 00 BA 01 91 20 00 BB 01 91 20 00 BC 01 91 20 00 BD 01 91 20 00 C8 01 91 20 00 C9 01 91 20 00 CA 01 91 20 00 CB 01 91 20 00 CC 01 91 20 00 CD 01 91 20 00 CE 01 91 20 00 CF 01 91 20 00 D0 01 91 20 00 D1 01 91 20 00 D2 01 91 20 00 D3 01 91 20 00 D4 01 91 20 00 D5 01 91 20 00 D6 01 91 20 00
CFG-VALGET - 06 8B 44 01 01 00 80 02 D7 01 91 20 00 D8 01 91 20 00 D9 01 91 20 00 DA 01 91 20 00 DB 01 91 20 00 DC 01 91 20 00 DD 01 91 20 00 DE 01 91 20 00 DF 01 91 20 00 E0 01 91 20 00 E6 01 91 20 00 E7 01 91 20 00 E8 01 91 20 00 E9 01 91 20 00 EA 01 91 20 00 F5 01 91 20 00 F6 01 91 20 00 F7 01 91 20 00 F8 01 91 20 00 F9 01 91 20 00 FF 01 91 20 00 00 02 91 20 00 01 02 91 20 00 02 02 91 20 00 03 02 91 20 00 04 02 91 20 00 05 02 91 20 00 06 02 91 20 00 07 02 91 20 00 08 02 91 20 00 09 02 91 20 00 0A 02 91 20 00 0B 02 91 20 00 0C 02 91 20 00 0D 02 91 20 00 0E 02 91 20 00 0F 02 91 20 00 10 02 91 20 00 11 02 91 20 00 12 02 91 20 00 13 02 91 20 00 14 02 91 20 00 15 02 91 20 00 16 02 91 20 00 17 02 91 20 00 27 02 91 20 00 28 02 91 20 00 29 02 91 20 00 2A 02 91 20 00 2B 02 91 20 00 2C 02 91 20 00 2D 02 91 20 00 2E 02 91 20 00 2F 02 91 20 00 30 02 91 20 00 31 02 91 20 00 32 02 91 20 00 33 02 91 20 00 34 02 91 20 00 35 02 91 20 00 36 02 91 20 00 37 02 91 20 00 38 02 91 20 00 39 02 91 20 00
CFG-VALGET - 06 8B 44 01 01 00 C0 02 3A 02 91 20 00 40 02 91 20 00 41 02 91 20 00 42 02 91 20 00 43 02 91 20 00 44 02 91 20 00 4A 02 91 20 00 4B 02 91 20 00 4C 02 91 20 00 4D 02 91 20 00 4E 02 91 20 00 54 02 91 20 00 55 02 91 20 00 56 02 91 20 00 57 02 91 20 00 58 02 91 20 00 59 02 91 20 00 5A 02 91 20 00 5B 02 91 20 00 5C 02 91 20 00 5D 02 91 20 00 5E 02 91 20 00 5F 02 91 20 00 60 02 91 20 00 61 02 91 20 00 62 02 91 20 00 63 02 91 20 00 64 02 91 20 00 65 02 91 20 00 66 02 91 20 00 67 02 91 20 00 68 02 91 20 00 69 02 91 20 00 6A 02 91 20 00 6B 02 91 20 00 6C 02 91 20 00 72 02 91 20 00 73 02 91 20 00 74 02 91 20 00 75 02 91 20 00 76 02 91 20 00 A4 02 91 20 00 A5 02 91 20 00 A6 02 91 20 00 A7 02 91 20 00 A8 02 91 20 00 13 03 91 20 00 14 03 91 20 00 15 03 91 20 00 16 03 91 20 00 17 03 91 20 00 2C 03 91 20 00 2D 03 91 20 00 2E 03 91 20 00 2F 03 91 20 00 30 03 91 20 00 31 03 91 20 00 32 03 91 20 00 33 03 91 20 00 34 03 91 20 00 35 03 91 20 00 36 03 91 20 00 37 03 91 20 00 38 03 91 20 00
CFG-VALGET - 06 8B 44 01 01 00 00 03 39 03 91 20 00 3A 03 91 20 00 45 03 91 20 00 46 03 91 20 00 47 03 91 20 00 48 03 91 20 00 49 03 91 20 00 4A 03 91 20 00 4B 03 91 20 00 4C 03 91 20 00 4D 03 91 20 00 4E 03 91 20 00 4F 03 91 20 00 50 03 91 20 00 51 03 91 20 00 52 03 91 20 00 53 03 91 20 00 54 03 91 20 00 55 03 91 20 00 56 03 91 20 00 57 03 91 20 00 58 03 91 20 00 59 03 91 20 00 5A 03 91 20 00 5B 03 91 20 00 5C 03 91 20 00 5D 03 91 20 00 86 03 91 20 00 87 03 91 20 00 88 03 91 20 00 89 03 91 20 00 8A 03 91 20 00 8B 03 91 20 00 8C 03 91 20 00 8D 03 91 20 00 8E 03 91 20 00 8F 03 91 20 00 00 04 91 20 00 01 04 91 20 00 02 04 91 20 00 03 04 91 20 00 04 04 91 20 00 01 00 92 20 00 02 00 92 20 00 03 00 92 20 00 04 00 92 20 00 05 00 92 20 00 06 00 92 20 07 07 00 92 20 07 08 00 92 20 07 09 00 92 20 07 0A 00 92 20 07 01 00 93 20 29 02 00 93 20 00 07 00 93 20 00 31 00 93 20 00 32 00 93 20 00 03 00 A2 20 00 05 00 A2 20 00 06 00 A3 20 0F 12 00 A3 20 0F 25 00 A3 20 03 36 00 A3 20 10 37 00 A3 20 0F
CFG-VALGET - 06 8B 5D 01 01 00 40 03 38 00 A3 20 08 51 00 A3 20 00 54 00 A3 20 00 55 00 A3 20 00 56 00 A3 20 00 01 00 C5 20 14 02 00 C5 20 8C 01 00 C6 20 08 04 00 C6 20 00 06 00 C6 20 01 08 00 C6 20 00 0A 00 C6 20 01 0C 00 C6 20 00 0E 00 C6 20 01 10 00 C6 20 00 12 00 C6 20 01 14 00 C6 20 00 16 00 C6 20 01 18 00 C6 20 00 1A 00 C6 20 01 1C 00 C6 20 00 1E 00 C6 20 01 20 00 C6 20 00 22 00 C6 20 01 24 00 C6 20 00 26 00 C6 20 01 28 00 C6 20 00 2A 00 C6 20 01 2C 00 C6 20 00 2E 00 C6 20 01 30 00 C6 20 00 32 00 C6 20 01 03 00 C7 20 16 01 00 D0 20 00 06 00 D0 20 00 07 00 D0 20 00 0B 00 D0 20 00 12 00 D0 20 01 01 00 F6 20 00 10 00 01 30 00 00 20 00 01 30 00 00 30 00 01 30 00 00 40 00 01 30 00 00 50 00 01 30 00 00 60 00 01 30 00 00 70 00 01 30 00 00 80 00 01 30 00 00 90 00 01 30 00 00 A0 00 01 30 00 00 B0 00 01 30 00 00 C0 00 01 30 00 00 D0 00 01 30 00 00 E0 00 01 30 00 00 10 01 01 30 00 00 20 01 01 30 00 00 30 01 01 30 00 00 40 01 01 30 00 00 50 01 01 30 00 00 60 01 01 30 00 00 70 01 01 30 00 00 80 01 01 30 00 00 90 01 01 30 00 00 A0 01 01 30 00 00 B0 01 01 30 00 00
CFG-VALGET - 06 8B 9A 01 01 00 80 03 C0 01 01 30 00 00 D0 01 01 30 00 00 E0 01 01 30 00 00 01 00 02 30 64 00 05 00 04 30 00 01 06 00 04 30 D5 00 07 00 04 30 00 01 08 00 04 30 D5 00 01 00 05 30 32 00 17 00 11 30 45 08 B1 00 11 30 FA 00 B2 00 11 30 FA 00 B3 00 11 30 64 00 B4 00 11 30 5E 01 B5 00 11 30 96 00 01 00 21 30 28 00 02 00 21 30 01 00 02 00 23 30 64 00 3B 00 25 30 00 00 15 00 26 30 00 00 16 00 26 30 00 00 06 00 34 30 46 00 08 00 34 30 91 00 0A 00 65 30 46 15 0B 00 65 30 A9 01 0C 00 65 30 00 00 33 00 93 30 00 00 04 00 A2 30 00 00 3C 00 A3 30 F4 01 45 00 A3 30 B0 04 46 00 A3 30 E8 03 48 00 A3 30 00 00 02 00 A5 30 78 05 0A 00 A5 30 FF 1F 05 00 C6 30 00 00 09 00 C6 30 00 00 0D 00 C6 30 00 00 11 00 C6 30 00 00 15 00 C6 30 00 00 19 00 C6 30 00 00 1D 00 C6 30 00 00 21 00 C6 30 00 00 25 00 C6 30 00 00 29 00 C6 30 00 00 2D 00 C6 30 00 00 31 00 C6 30 00 00 05 00 D0 30 00 00 13 00 D0 30 2C 01 05 00 DE 30 00 00 06 00 DE 30 00 00 07 00 DE 30 00 00 0A 00 F6 30 00 00 0B 00 F6 30 00 00 02 00 05 40 40 42 0F 00 03 00 05 40 40 42 0F 00 04 00 05 40 00 00 00 00 05 00 05 40 A0 86 01 00 06 00 05 40 00 00 00 00 0D 00 05 40 40 42 0F 00 0E 00 05 40 40 42 0F 00 0F 00 05 40 00 00 00 00 10 00 05 40 A0 86 01 00 11 00 05 40 00 00 00 00 24 00 05 40 01 00 00 00
CFG-VALGET - 06 8B 04 02 01 00 C0 03 25 00 05 40 01 00 00 00 26 00 05 40 01 00 00 00 27 00 05 40 01 00 00 00 64 00 11 40 00 00 00 00 65 00 11 40 00 00 00 00 66 00 11 40 00 00 00 00 67 00 11 40 00 00 00 00 68 00 11 40 00 00 00 00 69 00 11 40 00 00 00 00 6A 00 11 40 00 00 00 00 C1 00 11 40 00 00 00 00 C2 00 11 40 10 27 00 00 D1 00 11 40 00 00 00 00 D2 00 11 40 00 00 00 00 D3 00 11 40 00 00 00 00 21 00 24 40 00 00 00 00 22 00 24 40 00 00 00 00 23 00 24 40 00 00 00 00 31 00 24 40 00 00 00 00 32 00 24 40 00 00 00 00 33 00 24 40 00 00 00 00 41 00 24 40 00 00 00 00 42 00 24 40 00 00 00 00 43 00 24 40 00 00 00 00 51 00 24 40 00 00 00 00 52 00 24 40 00 00 00 00 53 00 24 40 00 00 00 00 12 00 34 40 F0 F1 FF FF 13 00 34 40 30 2A 00 00 01 00 52 40 00 96 00 00 01 00 53 40 00 96 00 00 28 00 A3 40 00 00 00 00 2A 00 A3 40 00 00 00 00 2B 00 A3 40 00 00 00 00 41 00 A3 40 00 00 00 00 42 00 A3 40 D0 07 00 00 43 00 A3 40 E8 03 00 00 44 00 A3 40 F4 01 00 00 4C 00 A3 40 00 04 04 00 4D 00 A3 40 B0 00 00 00 01 00 A4 40 00 60 E3 16 02 00 A4 40 00 60 E3 16 03 00 A4 40 00 B0 71 0B 04 00 A4 40 00 60 E3 16 05 00 A4 40 00 20 A1 07 06 00 A4 40 80 1A 06 00 07 00 A4 40 00 90 D0 03 08 00 A4 40 00 90 D0 03 09 00 A4 40 00 90 D0 03 0A 00 A4 40 00 20 A1 07 0B 00 A4 40 00 90 D0 03 0C 00 A4 40 00 24 F4 00 0D 00 A4 40 80 BA 8C 01 10 00 A4 40 00 B0 71 0B 01 00 A5 40 01 00 00 00 05 00 A5 40 FF FF FF 1F 06 00 A5 40 FF FF FF FF 07 00 A5 40 FF FF FF FF 08 00 A5 40 FF FF FF FF 09 00 A5 40 FF FF FF FF 01 00 A6 40 00 00 00 00 02 00 D0 40 0A 00 00 00 03 00 D0 40 0A 00 00 00 04 00 D0 40 00 00 00 00
CFG-VALGET - 06 8B 38 02 01 00 00 04 0F 00 D0 40 00 00 00 00 14 00 D0 40 2A 00 00 00 08 00 DE 40 00 00 00 00 2A 00 05 50 00 00 00 00 00 00 00 00 2B 00 05 50 00 00 00 00 00 00 24 40 2C 00 05 50 00 00 00 00 00 00 00 00 2D 00 05 50 00 00 00 00 00 00 24 40 62 00 11 50 00 00 00 40 A6 54 58 41 63 00 11 50 88 6D 74 96 1D A4 72 40 06 00 36 50 88 2B 07 00 00 00 00 00 0D 00 65 50 75 2D 62 6C 6F 78 20 41 0E 00 65 50 47 20 2D 20 77 77 77 2E 0F 00 65 50 75 2D 62 6C 6F 78 2E 63 10 00 65 50 6F 6D 00 00 00 00 00 00 11 00 65 50 75 2D 62 6C 6F 78 20 47 12 00 65 50 4E 53 53 20 72 65 63 65 13 00 65 50 69 76 65 72 00 00 00 00 14 00 65 50 00 00 00 00 00 00 00 00 15 00 65 50 00 00 00 00 00 00 00 00 16 00 65 50 00 00 00 00 00 00 00 00 17 00 65 50 00 00 00 00 00 00 00 00 18 00 65 50 00 00 00 00 00 00 00 00 26 00 A3 50 20 40 00 00 54 00 00 00 49 00 A3 50 4E 45 4F 2D 4D 39 4E 00 03 00 A5 50 4D 77 35 A3 ED 01 00 00 07 00 C6 50 00 00 00 00 00 00 00 00 0B 00 C6 50 00 00 00 00 00 00 00 00 0F 00 C6 50 00 00 00 00 00 00 00 00 13 00 C6 50 00 00 00 00 00 00 00 00 17 00 C6 50 00 00 00 00 00 00 00 00 1B 00 C6 50 00 00 00 00 00 00 00 00 1F 00 C6 50 00 00 00 00 00 00 00 00 23 00 C6 50 00 00 00 00 00 00 00 00 27 00 C6 50 00 00 00 00 00 00 00 00 2B 00 C6 50 00 00 00 00 00 00 00 00 2F 00 C6 50 00 00 00 00 00 00 00 00 33 00 C6 50 00 00 00 00 00 00 00 00 04 00 C7 50 4E 6F 74 69 63 65 3A 20 05 00 C7 50 6E 6F 20 64 61 74 61 20 06 00 C7 50 73 61 76 65 64 21 00 00 07 00 C7 50 00 00 00 00 00 00 00 00 02 00 F6 50 00 00 00 00 00 00 00 00 03 00 F6 50 00 00 00 00 00 00 00 00 04 00 F6 50 00 00 00 00 00 00 00 00 05 00 F6 50 00 00 00 00 00 00 00 00 06 00 F6 50 00 00 00 00 00 00 00 00 07 00 F6 50 00 00 00 00 00 00 00 00 08 00 F6 50 00 00 00 00 00 00 00 00
*/

#define PRINT_FOR_DEBUG false

#define M_PI 3.14159265358979323846

#define M_MIN_SATS 6

#define UBX_PAYLOAD_INDEX 2
#define UBX_PVT_HEADER_0  0xb5
#define UBX_PVT_HEADER_1  0x62
#define UBX_PVT_CLASS     0x01
#define UBX_PVT_ID        0x07

//extern DATA_Xchange data;
//extern Timer global_timer;

class NEOM9N
{
public:
    NEOM9N(PinName TX, PinName RX);
    virtual ~NEOM9N();

    typedef struct ubxNavPVT_s {
        uint32_t iTOW;    //  0  -   ms   GPS time of week of the navigation epoch
        uint16_t year;    //  4  -    -   Year (UTC)
        uint8_t month;    //  6  -    -   Month, range 1..12 (UTC)
        uint8_t day;      //  7  -    -   Day of month, range 1..31 (UTC)
        uint8_t hour;     //  8  -    -   Hour of day, range 0..23 (UTC)
        uint8_t min;      //  9  -    -   Minute of hour, range 0..59 (UTC)
        uint8_t sec;      // 10  -    -   Seconds of minute, range 0..60 (UTC)
        uint8_t fixType;  // 20  -    -   GNSSﬁx Type
        uint8_t numSV;    // 23  -    -   Number of satellites used in Nav Solution
        int32_t lon;      // 24 1e-7 deg  Longitude
        int32_t lat;      // 28 1e-7 deg  Latitude
        int32_t height;   // 32  -   mm   Height above ellipsoid
        uint32_t hAcc;    // 40  -   mm   Horizontal accuracy estimate
        uint32_t vAcc;    // 44  -   mm   Vertical accuracy estimate
        int32_t velN;     // 48  -   mm/s NED north velocity
        int32_t velE;     // 52  -   mm/s NED east velocity
        int32_t velD;     // 56  -   mm/s NED down velocity
        int32_t gSpeed;   // 60  -   mm/s Ground Speed (2-D)
        int32_t headMot;  // 64 1e-5 deg  Heading of motion (2-D)
        uint32_t sAcc;    // 68 -    mm/s Speed accuracy estimate
        uint32_t headAcc; // 72 1e-5 deg  Heading accuracy estimate (both motion and vehicle)
        //int16_t magDec;   // 88 1e-2 deg  Magnetic declination.
        //uint16_t magAcc;  // 90 1e-2 deg  Magnetic declination accuracy
    } ubxNavPVT_t;

    void start_loop();
    void reset_local();
    ubxNavPVT_t GetUbxNavPVT();
    Eigen::Vector3f GetPosECEF();
    Eigen::Vector3f GetPosENU();
    Eigen::Vector3f GetVelENU();
    uint8_t GetFixType();
    uint8_t GetNumSV();
    uint8_t GetGPSTimeOfWeek();
    float GetHeadMot();
    float GetHeadAcc();
    float GethAcc();
    float GetvAcc();
    float GetsAcc();

private:
    float m_Ts = 0.005f; // GNSS runs at 25 Hz := 0.04 sec, make sure that modulo(0.04 / m_Ts) = 0 e.g. m_Ts = 0.02, 0.01, 0.005
    BufferedSerial m_bufferedSerial;
    ubxNavPVT_t m_ubxNavPVT;
#if PRINT_FOR_DEBUG
    Timer m_run_timer;
#endif
    Eigen::Vector3d m_pos_ecef_0;
    Eigen::Vector3d m_pos_ecef;
    Eigen::Vector3d m_pos_enu;
    Eigen::Matrix3d m_R_ecefToLocal_0;

    ThreadFlag threadFlag;
    Thread thread;
    Ticker ticker;

    void update();
    Eigen::Vector3d transformWGS84ToECEF(const ubxNavPVT_t& ubxNavPVT);
    Eigen::Matrix3d getR_ECEFToLocal(const ubxNavPVT_t& ubxNavPVT);
    ubxNavPVT_t decodeUbxNavPVTmsg(const char *buf);
    void sendThreadFlag();
};

#endif /* NEOM9N_THREAD_H */

