#ifndef CONTROLLER_H_
#define CONTROLLER_H_

/* Cntrl_Libary */
#include "EncoderCounter.h"
#include "IIR_filter.h"
#include "LinearCharacteristics.h"
#include "PID_Cntrl.h"
#include "ThreadFlag.h"

class Controller
{
public:

    Controller(float Ts);

    virtual ~Controller();

    void           reset();
    void           start_loop();

private:

    Timer          user_button_timer, loop_timer;
    float          time_offset;
    bool           executeMainTask, isFirstTimeMeas;
    InterruptIn    user_button;

    float Ts;
    
    EncoderCounter encoderCounter;
    short          count_past;
    long           count;
    AnalogIn       u_accx, u_accy, u_gyro;
    AnalogOut      u_i;
    float          time, accx, accy, gyro, phi1, phi2, dphi2, M;   
    LinearCharacteristics u2accx, u2accy, u2gyro, i2u;
    IIR_filter     Gacc, Ggyro, Gdiff, Gf;
    PID_Cntrl      Ci;

    BufferedSerial bufferedSerial;
    char           buffer[200];
    int            write_counter, write_counter_write_val;

    Mutex          mutex;
    ThreadFlag     threadFlag;
    Thread         thread;
    Ticker         ticker;

    void           loop();
    void           sendThreadFlag();

    void           button_fall();
    void           button_rise();
};

#endif