/*
 * EncoderCounterROME2.h
 * Copyright (c) 2022, ZHAW
 * All rights reserved.
 */

#ifndef ENCODER_COUNTER_ROME2_H_
#define ENCODER_COUNTER_ROME2_H_

#include <cstdlib>
#include <mbed.h>

/**
 * This class implements a driver to read the quadrature
 * encoder counter of the STM32 microcontroller.
 */
class EncoderCounterROME2 {
    
    public:
        
                    EncoderCounterROME2(PinName a, PinName b);
        virtual     ~EncoderCounterROME2();
        void        reset();
        void        reset(short offset);
        short       read();
                    operator short();
        
    private:
        
        TIM_TypeDef*    TIM;
};

#endif /* ENCODER_COUNTER_ROME2_H_ */
