#ifndef EIGEN_QR_MODULE_H
#define EIGEN_QR_MODULE_H

#include "Core.h"

#include "src/Core/util/DisableStupidWarnings.h"

#include "Cholesky.h"
#include "Jacobi.h"
#include "Householder.h"

/** \defgroup QR_Module QR module
  *
  *
  *
  * This module provides various QR decompositions
  * This module also provides some MatrixBase methods, including:
  *  - MatrixBase::qr(),
  *
  * \code
  * #include <Eigen/QR>
  * \endcode
  */

#include "src/misc/Solve.h"
#include "src/QR/HouseholderQR.h"
#include "src/QR/FullPivHouseholderQR.h"
#include "src/QR/ColPivHouseholderQR.h"
#ifdef EIGEN_USE_LAPACKE
#include "src/QR/HouseholderQR_MKL.h"
#include "src/QR/ColPivHouseholderQR_MKL.h"
#endif

#ifdef EIGEN2_SUPPORT
#include "src/Eigen2Support/QR.h"
#endif

#include "src/Core/util/ReenableStupidWarnings.h"

#ifdef EIGEN2_SUPPORT
#include "Eigenvalues"
#endif

#endif // EIGEN_QR_MODULE_H
/* vim: set filetype=cpp et sw=2 ts=2 ai: */