#ifndef PID_CNTRL_H_
#define PID_CNTRL_H_

#include <math.h>
#define  pi 3.14159265358979323846

class PID_Cntrl
{

public:

    PID_Cntrl(float I, float Ts, float uMin, float uMax);
    PID_Cntrl(float P, float I, float Ts, float uMin, float uMax);
    PID_Cntrl(float P, float I, float D, float Ts, float uMin, float uMax);
    PID_Cntrl(float P, float I, float D, float tau_f, float Ts, float uMin, float uMax);
    PID_Cntrl(float P, float I, float D, float tau_f, float tau_ro, float Ts, float uMin, float uMax);

    PID_Cntrl() {};

    float operator()(float e)
    {
        return update(e);
    }
    float operator()(float e, float y)
    {
        return update(e, y);
    }

    virtual ~PID_Cntrl();

    void    reset();
    void    reset(float initValue);

    void    setup(float I, float Ts, float uMin, float uMax);
    void    setup(float P, float I, float Ts, float uMin, float uMax);
    void    setup(float P, float I, float D, float Ts, float uMin, float uMax);
    void    setup(float P, float I, float D, float tau_f, float Ts, float uMin, float uMax);
    void    setup(float P, float I, float D, float tau_f, float tau_ro, float Ts, float uMin, float uMax);

    void    setCoeff_P(float P);
    void    setCoeff_I(float D);
    void    setCoeff_D(float D);

    void    scale_PIDT2_param(float scale);

    float   update(float e);
    float   update(float e, float y);

    bool    update_param(int cntrlr_param, float value);

    void    set_limits(float uMin, float uMax);

    float   prewarp(float T, float Ts);

    float   get_ulimit();
    float   get_P_gain();
    float   get_bd();
    float   get_ad();

private:

    float   IPart, Dpart, d_old, u_old, uf;
    float   P, I, D, tau_f, tau_ro, Ts, uMin, uMax;
    float   bi, bd, ad, bf, af;
    float   P_init, I_init, D_init;

    void    setCoefficients(float P, float I, float D, float tau_f, float tau_ro, float Ts);

    void    updateCoeff_I(float I, float Ts);
    void    updateCoeff_D(float D, float Ts, float tau_f);
    void    updateCoeff_RO(float Ts, float tau_ro);

    float   saturate(float u, float uMin, float uMax);

};

#endif