#ifndef MLXLINMASTER_H
#define MLXLINMASTER_H

#include "mbed.h"

#include "linmsg.h"

class LinMaster {
public:
    LinMaster(PinName txpin, PinName rxpin); //initializes serial connection with specified rx/tx pins @115.2Kbaud
     
    enum commandCode
    {
        CMDRESETHARDWARE = 0,
        CMDHARDWAREID = 1,
        CMDSOFTWAREID = 3,
        CMDCONFIGUREMASTER = 151,
        CMDSENDLINMSG = 152,
        CMDREADLASTLINMSG = 153,
        CMDSENDWAKEUP = 157
    };
    
    enum T_baudrate
    {
        B10400 = 23,
        B19200 = 12
    };
    
    enum linMsgType
    {
        S2M = 0,
        M2S = 1
    };
    
    /*
    *sends command to LIN Master
    *includes data required to satisfy command parameters
    *Returns 0 on success
    *Returns -1 if command success cannot be verified
    */
    int sendCommand(char command, char *msgData = NULL, int length = 0); 
    
    /*
    *calculates message checksum value
    *modulu 256 used over entire message excuding header
    */
    char calculateChecksum(char command, char *msgData, int length);
    
    /*
    *Send Lin Message over bus
    */
    char sendOverBus(LinMsg *message);
    
    
    /*
    *choose
    */
    void setBaudrate(T_baudrate baudrate);
  
private:  
    Serial Master;
    char msgResponse[16];
    int responseLength;
    bool responseIsValid;
    T_baudrate m_baudrate;
};

#endif