/****************************************************************/
/* a class implementing a LIN message                       */
/****************************************************************/
#ifndef LinMsg_H
#define LinMsg_H

#include "mbed.h"

enum T_msgoption {MSG_M2S, MSG_S2M, MSG_UAD, MSG_INT, MSG_IDS, MSG_WKU};        // global enumeration type
enum T_checksumType {CLASSIC, ENHANCED};                //checksum type enumeration

class LinMsg
{
    public:
        LinMsg();                                       // default constructor
                                               
        LinMsg(                                         // constuctor
        int ID,                                         // LIN ID NOT PID
        int NbBytes,                                    // # of data bytes in lin message
        enum T_msgoption option,                        // type of msg, M2S, S2M, Wakeup...
        enum T_checksumType ckType);                    // classic or enhanced checksum
        
        LinMsg(                                         // constuctor
        int ID,                                         // LIN ID NOT PID
        int NbBytes,                                    // # of data bytes in lin message
        char DataBytes[8],                              // data bytes of message
        enum T_msgoption option,                        // type of msg, M2S, S2M, Wakeup...
        enum T_checksumType ckType);                    // classic or enhanced checksum
        
        int GetId();                                    // returns the ID of the LIN message without parity bits
        int GetIdPar();                                 // returns the ID of the LIN message with parity bits
        int GetNbBytes();                               // returns the number of bytes in the LIN message
        void SetDatabytes(char Bytes[]);                // set the databytes in the message
        int GetDatabyte(int index);                     // returns the databyte at the give index
        int SetDatabyte(int index, char value);           // returns 0 if successful, returns -1 if out of range
        void SetChecksum(int ck);                       // in case of a S2M message, copy the checksum from the message
        int GetChecksum();                              // returns the checksum if a receive message
        T_msgoption GetCategory();                      // return the category the message belongs to
        void SetId(int ID);                             // set the ID of the LIN message
        void SetNbBytes(int NbBytes);                   // set the number of bytes of the LIN message
        int CalculateParity(int value);                 // calulates the LIN paritybits of a byte
        int CalculateChecksum();                        // calculate the checksum of the LIN message when a M2S message

    private:
        int m_checksum;                                 // checksum
        int m_LinId;                                    // the ID of the LIN message
        int m_NbBytes;
        char m_Bytes[8];                                // an array with the databytes
        T_msgoption m_category;                         // message category
        T_checksumType m_ckType;                        //checksum type
};

#endif
