/************************************************************/
/* implementationfile of the LIN message class  */
/************************************************************/

#include "linmsg.h"
//#include "mbed.h"

/*------------------------------------------------------------------------
// default constuctor
//  input:
// result: creates an instance of the LinMsg object
// output:
*/
LinMsg::LinMsg()
{}

/*------------------------------------------------------------------------
//constuctor  1
// input: a LIN ID as an integer,
//        the number of bytes a message consists of
// result: sets the ID of the message, the number of bytes and all the databytes to -1
// output:
*/
LinMsg::LinMsg(int ID, int NbBytes, T_msgoption category, T_checksumType ckType)
{
    char i[8]={0,0,0,0,0,0,0,0};
    SetId(ID);
    SetNbBytes(NbBytes);
    SetDatabytes(i);
    m_category = category;
    m_ckType = ckType;
}

/*------------------------------------------------------------------------
//constuctor
// input: a LIN ID as an integer,
//        the number of bytes a message consists of,
//        the databyes of a message (an 8 bytes long array)
// result: sets the ID of the message
// output:
*/
LinMsg::LinMsg(int ID, int NbBytes, char DataBytes[8], T_msgoption category, T_checksumType ckType)
{
    SetId(ID);
        SetNbBytes(NbBytes);
        SetDatabytes(DataBytes);
        m_category = category;
        m_ckType = ckType;
}

/*------------------------------------------------------------------------
//void SetNbBytes(int ID)
// input: a number of bytes
// result: the m_NbBytes variable has the correct value
// output:
*/
void LinMsg:: SetNbBytes(int NbBytes)
{
    m_NbBytes = NbBytes;
}

/*------------------------------------------------------------------------
//void SetId(int ID)
// input: a LIN ID as an integer
// result: the m_ID variable has the correct value without the parity
// output:
*/
void LinMsg:: SetId(int ID)
{
    m_LinId = ID;
}

/*------------------------------------------------------------------------
//int GetId()
//input:
// result:
//output: the LIN ID without the parity bits
*/
int LinMsg::GetId()
{
    return m_LinId;
}

/*------------------------------------------------------------------------
//int GetDatabyte(int index)
//input: the index of the LIN databyte
// result:
// output: the LIN databyte on the specified index
*/
int LinMsg::GetDatabyte(int index)
{
        if (index > GetNbBytes()-1)
                return -1;
    return m_Bytes[index];
}

/*------------------------------------------------------------------------
//int SetDatabyte(int index)
//input: the index of the LIN databyte to set value
//input: value to set databyte
// result: writes new value to indexed databyte
// output: 0 if no errors, -1 if out range
*/
int LinMsg::SetDatabyte(int index, char value)
{
    if ((index > (GetNbBytes()-1)) || (index < 0))
    {
        return -1;
    }
    m_Bytes[index] = value;
    return 0;
}

/*------------------------------------------------------------------------
//int GetIdPar()
// input: none
// result:
// output: the LIN ID with the parity bits
*/
int LinMsg::GetIdPar()
{
        return CalculateParity(GetId());
}

/*------------------------------------------------------------------------
//int GetNbBytes()
// input: none
// result:
// output: the number of bytes of the LIN message
*/
int LinMsg::GetNbBytes()
{
        return m_NbBytes;
}

/*------------------------------------------------------------------------
//int CalcutaleParity(int value)
// input: value, the byte who's parity has to be calculated
// result:
// output: the byte with the parity
*/
int LinMsg::CalculateParity(int value)
{
        int P0;
        int P1;
        P0=0;
        P1=0;

        if (value&(1<<0)){P0=~P0;}
        if (value&(1<<1)){P0=~P0;}
        if (value&(1<<2)){P0=~P0;}
        if (value&(1<<4)){P0=~P0;}

        if (value&(1<<1)){P1=~P1;}
        if (value&(1<<3)){P1=~P1;}
        if (value&(1<<4)){P1=~P1;}
        if (value&(1<<5)){P1=~P1;}
        P1=~P1;

        value=value & 0x3f;  //delete MSB's
        if (P0) { value=value | (1<<6);}
        if (P1) { value=value | (1<<7);}

        return (value);
}

/*------------------------------------------------------------------------
//void SetDatabytes(int* Bytes[])
// input: Bytes, the bytes in the datapart of the message
// result: the bytes are set
// output:
*/
void LinMsg::SetDatabytes(char Bytes[])
{
        int i;
        int j;
        int k = GetNbBytes();
        for (i = 0; i < 8; i++)                  // clear the databytes
                m_Bytes[i] = 0;
        for (j = 0; j < k; j++)     // set the databytes
               m_Bytes[j] = Bytes[j];
}

/*------------------------------------------------------------------------
//int CalculateChecksum()
// input:
// result:
// output: the LIN checksum. The ID fiels is not included
*/
int LinMsg::CalculateChecksum()
{
    int ck;
    if(m_ckType == ENHANCED)
    {
        ck = GetIdPar();
    }
    else
    {
        ck = 0;    
    }
   
    for (int i=0; i<GetNbBytes(); i++)
    {
        ck = ck + GetDatabyte(i);
        if (ck > 255)
        ck = ck-256+1;
    }
    return 255-ck;
}

/*------------------------------------------------------------------------
//int GetChecksum()
// input:
// result:
// output: the checksum if
*/
int LinMsg::GetChecksum()
{
    int ck;
    switch (m_category)
    {
        case MSG_M2S:
            ck =  CalculateChecksum();
        break;

        case MSG_S2M:
            ck =  m_checksum;
        break;

        case MSG_UAD:
            ck =  CalculateChecksum();
        break;

        case MSG_INT:
            ck =  m_checksum;
        break;

        case MSG_IDS:
            ck =  m_checksum;
        break;

        default:                                        // all the other cases (Wake Up messages)
            return -1;
        }
    return ck;
}

/*------------------------------------------------------------------------
//int GetCategory()
// input:
//  result:
//  output: the category the message belongs to
*/
T_msgoption LinMsg::GetCategory()
{
    return m_category;
}

/*------------------------------------------------------------------------
// int SetChecksum(int ck)
//  input: the receive checksum that has to be set
//  result:
//  output:
*/
void LinMsg::SetChecksum(int ck)
{
    m_checksum = ck;
}