#include "mbed.h"
#include "LIN/LinMaster.h"

/*
*Author: PMK
*Connect MLX80020 EVB from Melexis to enable MBED to act as a LIN Master
*This example sends messages specific to Melexis LIN RGB nodes with FW V 4.1.3
*/

/********* Configurable Data for LIN RGB portion **********/
DigitalIn LINtransReset(p8);    //p8 can be connected to enable of LIN Transceiver
LinMaster LinMaster(p10, p9);   /* p10 = RXD, p9 = TXD */

const char NUMBEROFNODES = 20;  //Number of RGB slave devices
const char FIRSTNAD = 0x61;     //Node address of first RGB slave in string

/**********************************************************/

LinMaster::Frame_t M2SFrame =
{
    LinMaster::M2S,                 // Direction
    LinMaster::Enhanced,            // CRC Type
    LinMaster::Normal,              // Break Type
    8,                              // Data Length
    0x24,                           // Frame ID
    {0x7F, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00}  // Data BroadCast + LEDs OFF + USE NAD
};

LinMaster::Frame_t S2MFrame =
{
    LinMaster::S2M,                 // Direction
    LinMaster::Enhanced,            // CRC Type
    LinMaster::Normal,              // Break Type
    8,                              // Data Length
    0x05,                           // Frame ID
    {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}  // Data BroadCast + LEDs OFF + USE NAD
};

void SetLED(int Address, int OnOff, int R, int G, int B, int I, int FadingTime, int FadingOnOff);
void SetIntensity(int arg);
void SetLEDsOnOff(int arg);
void SetFadingTime(int arg);
void SetFadingOnOff(int arg);

int main()
{
   
    //************ LIN Initialization ************************
    LINtransReset.mode(PullUp); //set enable high
    (void)LinMaster.init();     //initialize lin driver
    LinMaster.baudrate(19200);  //set lin baudrate
    wait_ms(500); //For init() to be completed
    //*******************************************************
        
    SetLED(127, 1, 0, 255, 0, 0, 0, 0); //turn All LEDS Off
    wait_ms(20);

    for(;;)
    {
        SetLED(FIRSTNAD + (rand()%NUMBEROFNODES), 1, rand()%255, rand()%255, rand()%255, rand()%100, 1, 1); //set random node to random color and intensity
        wait_ms(40);    //delay 40ms
        LinMaster.send_frame(&S2MFrame);    //Send S2M message to get VS voltage form nodes
        while(LinMaster.status() != LinMaster::IDLE); //wait for bus to become idle before rtreiving data from slvae
        LinMaster.get_rx_data(S2MFrame);    //move data form slave into data bytes of S2MFrame
        wait_ms(40);    //delay 40ms
    }
}

void SetLED(int Address, int OnOff, int R, int G, int B, int I, int FadingOnOff, int FadingTime)
{
    M2SFrame.Data[0] = Address;
    SetLEDsOnOff(OnOff);
    SetFadingTime(FadingTime);
    SetFadingOnOff(FadingOnOff);
    SetIntensity(I);
    M2SFrame.Data[5] = R;
    M2SFrame.Data[6] = G;
    M2SFrame.Data[7] = B;
   
    LinMaster.send_frame(&M2SFrame);
    //while(LinMaster.status() != LinMaster::IDLE);
}

void SetLEDsOnOff(int arg)
{
    if (arg == 1 or arg == 0)
    {   
        M2SFrame.Data[2] = (M2SFrame.Data[2] & 0x7F) | (arg << 7);
    }    
}

void SetFadingTime(int arg)
{
    if (arg >= 0 and arg <= 63) //FadingTime = 0-6.3ms, in steps of 100ms
    {
        M2SFrame.Data[3] = (M2SFrame.Data[3] & 0xC0) | (arg & 0x3F);
    }     
}

void SetFadingOnOff(int arg)
{
    if (arg == 1 or arg == 0)
    {   
        M2SFrame.Data[4] = (M2SFrame.Data[4] & 0x7F) | (arg << 7);
    }   
}

void SetIntensity(int arg)
{
    if (arg >= 0 and arg <= 100)
    {   
        M2SFrame.Data[4] = (M2SFrame.Data[4] & 0x80) | (arg & 0x7F);
    }  
}