/*
Demo code to show how to send Lin Messages to Melexis LIN RGB strip
Author: PMK
Date: July 14 2014
*/
#include "linmsg.h"
#include "mlxlinmaster.h"
#include "mbed.h"


LinMaster master(p9, p10); //open lin master comm for normal application choosing which pins for serial communication

/*
*NAD = 0x00-0x7F, 0x7F == broadcast to all nodes
*ledOn: true == led is on, false == led is off
*fadingOn: true == usnig fading time, false == instant change
*fading time == fading time(0-6.3s, in 100ms increments)
*intensity == 0-15, 15 being most intense
*red: 0-255
*gren: 0-255
*blue: 0-255
*/
void SendRGBMessage(char NAD, bool ledOn, bool fadingOn, char fadingTime, char intensity, char red, char green, char blue)
{
    char rgbFrameData[8];
    rgbFrameData[0] = 0x80 | NAD;       //set NAD with Broad = 1
    rgbFrameData[1] = 0;                //GID LSB = 0
    rgbFrameData[2] = 0;                //GID MSB = 0
    rgbFrameData[3] = fadingTime;       //set fading time + update immediatley
    rgbFrameData[4] = (fadingOn << 7) | (ledOn << 5) | (1 << 4) | intensity;   //set fading enable/disable, led on/off, preselected color = off, intensity
    rgbFrameData[5] = red;              //set red
    rgbFrameData[6] = green;            //set green
    rgbFrameData[7] = blue;             //set blue
    LinMsg rgbFrame(0x24, 8, rgbFrameData, MSG_M2S, ENHANCED);
    master.sendOverBus(&rgbFrame);
}


int main()
{   
    //
    while(1)
    {
        SendRGBMessage(0x61+(rand()%12), true, true, 2, 10, rand()%255, rand()%255, rand()%255);
        wait_ms(20);
    }
    
    
    return 0;

}