/***************************************************************************//**
 *   @file   ad7606_data_capture.h
 *   @brief  Header for AD7606 data capture interfaces
********************************************************************************
 * Copyright (c) 2020 Analog Devices, Inc.
 *
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
*******************************************************************************/

#ifndef AD7606_DATA_CAPTURE_H_
#define AD7606_DATA_CAPTURE_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/
#include <stddef.h>

#include "ad7606.h"
#include "ad7606_support.h"

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/* This is a number of bytes read in single query of read IIO buffer */
#define	IIO_DATA_BUFFER_RD_SIZE	(256)

/* Total number of samples to be read in one go are equal to buffer read size */
#define NO_OF_SAMPLES			(IIO_DATA_BUFFER_RD_SIZE)

/******************************************************************************/
/********************** Variables and User Defined Data Types *****************/
/******************************************************************************/

/******************************************************************************/
/************************ Public Declarations *********************************/
/******************************************************************************/

int32_t iio_data_capture_init(struct ad7606_dev *device);
int32_t single_data_read(void *device, uint8_t chn, polarity_e polarity);
void buffered_data_read(char *pbuf, size_t bytes, size_t offset,
			uint32_t chn_mask);
void do_conversion_callback(void);
void start_background_data_conversion(void);
void stop_background_data_conversion(void);

#endif /* AD7606_DATA_CAPTURE_H_ */
