/***************************************************************************//**
 *   @file   iio_transport.h
 *   @brief  Header file of iio_transport.
 *   @author
********************************************************************************
 * Copyright (c) 2020 Analog Devices, Inc.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
*******************************************************************************/

#ifndef IIO_TRANSPORT_H_
#define IIO_TRANSPORT_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include "iio.h"
#include "platform_drivers.h"

/******************************************************************************/
/********************** Macros and Constants Definition ***********************/
/******************************************************************************/

/* Baud rate for IIO UART interface */
#define IIO_UART_BAUD_RATE	(230400U)

/******************************************************************************/
/*************************** Types Declarations *******************************/
/******************************************************************************/

/******************************************************************************/
/************************ Functions Declarations ******************************/
/******************************************************************************/

/* UART peripheral init wrapper */
int32_t iio_uart_init(struct uart_desc **desc, struct uart_init_param *param);

/* UART data write wrapper */
ssize_t iio_uart_write(const char *buf, size_t len);

/* UART data read wrapper */
ssize_t iio_uart_read(char *buf, size_t len);

/* IIO command detect monitor */
bool is_new_iio_command_detected(void);

/* Check for specific IIO command */
bool check_iio_cmd(const char *cmd_str, uint8_t len);

/* IIO UART receive interrupt callback function */
void iio_uart_rx_callback(void);

#endif /* IIO_TRANSPORT_H_ */
