/***************************************************************************//**
*   @file   iio_ad7606.h
*   @brief  Header file of iio_ad7606
********************************************************************************
* Copyright (c) 2020 Analog Devices, Inc.
*
* All rights reserved.
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*******************************************************************************/
#ifndef IIO_AD7606_H_
#define IIO_AD7606_H_

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

#include <stdio.h>
#include <stdbool.h>
#include "iio.h"
#include "iio_types.h"

/******************************************************************************/
/****************************** Macros ****************************************/
/******************************************************************************/

/******************************************************************************/
/*************************** Types Declarations *******************************/
/******************************************************************************/

/**
 * @struct iio_ad7606_init_param
 * @brief Device configuration structure.
 */
struct iio_ad7606_init_param {
	/** ad7606 device instance pointer */
	struct ad7606_dev *ad7606_phy;
};

/**
 * @struct iio_ad7606_desc
 * @brief Structure holding IIO descriptor.
 */
struct iio_ad7606_desc {
	/** iio_interface instance pointer */
	struct iio_interface *iio_interface;
};

/******************************************************************************/
/************************ Functions Declarations ******************************/
/******************************************************************************/

/* Init AD7606 IIO interface */
int32_t iio_ad7606_init(struct iio_ad7606_desc **desc,
			struct iio_ad7606_init_param *init);

/* Free the resources allocated for IIO device */
int32_t iio_ad7606_remove(struct iio_ad7606_desc *desc);

/* Init the IIO interface */
int32_t ad7606_iio_initialize(void);

/* Run the IIO event handler */
void ad7606_iio_event_handler(void);

/* Init the IIO application */
int32_t ad7606_app_initialize(void);

#endif /* IIO_AD7606_H_ */
