/*************************************************************************//**
 *   @file   app_config.h
 *   @brief  Configuration file for AD7606 device applications
******************************************************************************
* Copyright (c) 2020 Analog Devices, Inc.
*
* All rights reserved.
*
* This software is proprietary to Analog Devices, Inc. and its licensors.
* By using this software you agree to the terms of the associated
* Analog Devices Software License Agreement.
*****************************************************************************/

#ifndef _APP_CONFIG_H_
#define _APP_CONFIG_H_

#include <stdint.h>
#include <PinNames.h>

// **** Note for User: ACTIVE_DEVICE selection ****//
/* Define the device type here from the list of below device type defines
 * (one at a time. Defining more than one device can result into compile error).
 * e.g. #define DEV_AD7606B -> This will make AD7606B as an ACTIVE_DEVICE.
 * The ACTIVE_DEVICE is default set to AD7606B if device type is not defined.
 * */

#define DEV_AD7606B


#if defined(DEV_AD7605_4)
#define ACTIVE_DEVICE		ID_AD7605_4
#define ACTIVE_DEVICE_NAME	"AD7605-4-phy"
#elif defined(DEV_AD7606_4)
#define ACTIVE_DEVICE		ID_AD7606_4
#define ACTIVE_DEVICE_NAME	"AD7606-4-phy"
#elif defined(DEV_AD7606_6)
#define ACTIVE_DEVICE		ID_AD7606_6
#define ACTIVE_DEVICE_NAME	"AD7606-6-phy"
#elif defined(DEV_AD7606_8)
#define ACTIVE_DEVICE		ID_AD7606_8
#define ACTIVE_DEVICE_NAME	"AD7606-8-phy"
#elif defined(DEV_AD7606B)
#define ACTIVE_DEVICE		ID_AD7606B
#define ACTIVE_DEVICE_NAME	"AD7606B-phy"
#elif defined(DEV_AD7606C_16)
#define ACTIVE_DEVICE		ID_AD7606C_16
#define ACTIVE_DEVICE_NAME	"AD7606C-16-phy"
#elif defined(DEV_AD7606C_18)
#define ACTIVE_DEVICE		ID_AD7606C_18
#define ACTIVE_DEVICE_NAME	"AD7606C-18-phy"
#elif defined(DEV_AD7608)
#define ACTIVE_DEVICE		ID_AD7608
#define ACTIVE_DEVICE_NAME	"AD7608-phy"
#elif defined(DEV_AD7609)
#define ACTIVE_DEVICE		ID_AD7609
#define ACTIVE_DEVICE_NAME	"AD7609-phy"
#else
#warning No/Unsupported ADxxxxy symbol defined. AD7606B defined
#define DEV_AD7606B
#define ACTIVE_DEVICE		ID_AD7606B
#define ACTIVE_DEVICE_NAME	"AD7606B-phy"
#endif


#if defined(DEV_AD7605_4)
#define	NO_OF_CHANNELS		4
#define ADC_RESOLUTION		16
#elif defined(DEV_AD7606_4)
#define	NO_OF_CHANNELS		4
#define ADC_RESOLUTION		16
#elif defined(DEV_AD7606_6)
#define	NO_OF_CHANNELS		6
#define ADC_RESOLUTION		16
#elif defined(DEV_AD7606_8)
#define	NO_OF_CHANNELS		8
#define ADC_RESOLUTION		16
#elif defined(DEV_AD7606B)
#define	NO_OF_CHANNELS		8
#define ADC_RESOLUTION		16
#elif defined(DEV_AD7606C_16)
#define	NO_OF_CHANNELS		8
#define ADC_RESOLUTION		16
#elif defined(DEV_AD7606C_18)
#define	NO_OF_CHANNELS		8
#define ADC_RESOLUTION		18
#elif defined(DEV_AD7608)
#define	NO_OF_CHANNELS		8
#define ADC_RESOLUTION		18
#elif defined(DEV_AD7609)
#define	NO_OF_CHANNELS		8
#define ADC_RESOLUTION		18
#else
/* Default config for AD7606B */
#define	NO_OF_CHANNELS		8
#define ADC_RESOLUTION		16
#endif

/* ADC max count (full scale value) for unipolar inputs */
#define ADC_MAX_COUNT_UNIPOLAR	(uint32_t)((1 << ADC_RESOLUTION) - 1)

/* ADC max count (full scale value) for bipolar inputs */
#define ADC_MAX_COUNT_BIPOLAR	(uint32_t)(1 << (ADC_RESOLUTION-1))

// Pin mapping of AD7606 w.r.t Arduino (reference: PinNames.h)
#define SPI_SS		D10
#define SPI_MOSI	D11
#define SPI_MISO	D12
#define SPI_SCK		D13

#define UART_TX		USBTX
#define	UART_RX		USBRX

#define	OSR0_PIN	D2
#define	OSR1_PIN	D3
#define	OSR2_PIN	D4
#define RESET_PIN	D5
#define CONVST_PIN	D6
#define BUSY_PIN	D7
#define RANGE_PIN	D8
#define STDBY_PIN	D9

#define LED_GREEN	LED3


#endif //_APP_CONFIG_H_
