/***************************************************************************//**
 *   @file   platform_drivers.h
 *   @brief  Header file of Generic Platform Drivers.
********************************************************************************
 * Copyright 2017, 2019-20(c) Analog Devices, Inc.
 *
 * All rights reserved.
 *
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 * By using this software you agree to the terms of the associated
 * Analog Devices Software License Agreement.
*******************************************************************************/

#ifndef PLATFORM_DRIVERS_H_
#define PLATFORM_DRIVERS_H_


// Platform drivers needs to be C-compatible to work with other drivers
#ifdef __cplusplus
extern "C"
{
#endif //  _cplusplus


/******************************************************************************/
/********************** Macros and Constants Definitions **********************/
/******************************************************************************/

// spi_init(), i2c_init(), i2c_write() and i2c_read() function are already defined
// in mbed-os libraries. To avoid this naming conflict, the functions are wrapped
// with suffix _noos using macros.

#define  spi_init(desc, init_param)         spi_init_noos(desc, init_param)

#define  i2c_init(desc, init_param)                      i2c_init_noos(desc, init_param)
#define  i2c_write(desc, data, bytes_number, stop_bits)  i2c_write_noos(desc, data, bytes_number, stop_bits)
#define  i2c_read(desc, data, bytes_number, stop_bits)   i2c_read_noos(desc, data, bytes_number, stop_bits)

/******************************************************************************/
/***************************** Include Files **********************************/
/******************************************************************************/

/*
#include "include/irq.h"
#include "include/util.h"
#include "include/delay.h"
#include "include/error.h"
#include "include/gpio.h"
#include "include/i2c.h"
#include "include/spi.h"
#include "include/uart.h" */

#include "irq.h"
#include "util.h"
#include "delay.h"
#include "error.h"
#include "gpio.h"
#include "i2c.h"
#include "spi.h"
#include "uart.h"


#ifdef __cplusplus  // Closing extern c
}
#endif //  _cplusplus

#endif // PLATFORM_DRIVERS_H_
