// Example to set up an interrupt based on the LPC TIMER0 match register, sford
 
#include "mbed.h"
#include "SDFileSystem.h"

#define VERSION "LED Master version 0.0"

void timer0_init(void);
void timer1_init(void);
void flipT0();
void flipT1();

#define FOLDER "/sd/"
//#define FOLDER "/local/"
#define STX 0x02
#define ETX 0x03
#define CR 0x0A
#define LF 0x0D
#define I2C_Hz 2500000      //I2C CLOCK
#define SPI_Hz 2500000      //SPI CLOCK
#define BAUD_RATE 19200     //RS-232C BaudRate
#define NAME_SIZE 20        //FileName Length
#define FILES_MAX 20        //FileList MAX
#define DATA_SIZE 12        //I2C DataSize
#define CMD_SIZE 3          //I2C CommandSize
#define PMT_SIZE 4          //I2C ParametersSize
#define W_DOT 256           //Display W_DotSize
#define H_DOT 32            //Display H_DotSize
#define SP_DOT 0            //Display SP_DotSize
#define RX_SIZE 2048        //Comm ReceiveSize

#define FILEHEADERSIZE 14   //Bitmap FileHeaderSize
#define INFOHEADERSIZE 40   //Bitmap InfoHeaderSize
#define HEADERSIZE (FILEHEADERSIZE+INFOHEADERSIZE)  //BitmapHeaderSize

InterruptIn inp1(p21);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut out1(p22);
DigitalOut out2(p23);

Serial uart(p13, p14); // tx, rx
SPI spi(p5, p6, p7); // mosi, miso, sck
I2C i2c0(p9, p10); // sda, scl
I2C i2c1(p28, p27); // sda, scl
SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sclk, cs, name
LocalFileSystem local("local");

static unsigned short Luminance0[DATA_SIZE] = {0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static unsigned short Luminance1[DATA_SIZE] = {0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00};
static unsigned short Luminance2[DATA_SIZE] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF};
static unsigned short Luminance3[DATA_SIZE] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00};
static unsigned short Luminance4[DATA_SIZE] = {0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF};
static unsigned short Luminance5[DATA_SIZE] = {0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
static unsigned short Luminance6[DATA_SIZE] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
static unsigned short Luminance7[DATA_SIZE] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned short tflag;
static int offlineCnt;
static int offlineColor;
static int offlineChange;           //Display Offline
static unsigned short offlineMode;
static unsigned short imageflag;
static int rxCnt;                   //Receive Count
static int rxFlag;                  //1:Data Receive Complete 2:Data Transfer 3:Disylay Start
static int rxDataFlag;              //RGB Receive Flag
static int rxTime;                  //Receive TimeOver
static int cmd;                     //1:Still Image 2:Left Flow 3:Right Flow 4:Down Flow 5:Up Flow
static int imageNo;
static int fileCnt;                 //FileList Count
static char files[FILES_MAX][NAME_SIZE];
static unsigned char rxData;
static unsigned char rxCmd[CMD_SIZE+1];
static unsigned char rxPmt[PMT_SIZE];
static unsigned char rxStrR[RX_SIZE];
static unsigned char rxStrG[RX_SIZE];
static unsigned char rxStrB[RX_SIZE];
static unsigned long rxLEDR[W_DOT];
static unsigned long rxLEDG[W_DOT];
static unsigned long rxLEDB[W_DOT];
static unsigned long imgLEDR[W_DOT];
static unsigned long imgLEDG[W_DOT];
static unsigned long imgLEDB[W_DOT];
static unsigned short i2cdata[DATA_SIZE];
static unsigned short i2cdata2[DATA_SIZE];
static int rotIndex;                //Rotational Position
static int rotCntX;                 //Rotational CountX(WScroll)
static int rotCntY;                 //Rotational CountY(HScroll)
static int rotY;                    //Rotational YPosition
static int rotSpeed;                //Rotational Flow Speed
static int rotStop;                 //Rotational Stop Count
static unsigned long nowCount;      //100usec Count

void timer0_init(void)
{ 
    // power up TIMER0 (PCONP[1])
    LPC_SC->PCONP |= 1 << 1; 

    // reset and set TIMER0 to timer mode
    LPC_TIM0->TCR = 0x2;  
    LPC_TIM0->CTCR = 0x0; 
    
    // set no prescaler
    LPC_TIM0->PR = 0;

    // calculate period (1 interrupt every second)
    uint32_t period = SystemCoreClock / 4; 

    // set match register and enable interrupt    
    LPC_TIM0->MR0 = period;
    LPC_TIM0->MCR |= 1 << 0;    // interrupt on match
    LPC_TIM0->MCR |= 1 << 1;    // reset on match

    // enable the vector in the interrupt controller
    NVIC_SetVector(TIMER0_IRQn, (uint32_t)&flipT0);
    NVIC_EnableIRQ(TIMER0_IRQn);

    // start the timer
    LPC_TIM0->TCR = 1;
}

void timer1_init(void)
{ 
    // power up TIMER1 (PCONP[1])
    LPC_SC->PCONP |= 1 << 0x16; 

    // reset and set TIMER1 to timer mode
    LPC_TIM1->TCR = 0x2;  
    LPC_TIM1->CTCR = 0x0; 
    
    // set no prescaler
    LPC_TIM1->PR = 0;

    // calculate period (1 interrupt every second)
    uint32_t period = SystemCoreClock / 4; 

    // set match register and enable interrupt    
    LPC_TIM1->MR0 = period / 2;
    LPC_TIM1->MCR |= 1 << 0;    // interrupt on match
    LPC_TIM1->MCR |= 1 << 1;    // reset on match

    // enable the vector in the interrupt controller
    NVIC_SetVector(TIMER1_IRQn, (uint32_t)&flipT1);
    NVIC_EnableIRQ(TIMER1_IRQn);

    // start the timer
    LPC_TIM1->TCR = 1;
}

//**********************************************************************
//Timer0 Init
//**********************************************************************
void flipT0()
{
    // do something!
    led1 = !led1;
    
    // clear the TIMER0 interrupt
    LPC_TIM0->IR = 1;
}

//**********************************************************************
//Timer0 Init
//**********************************************************************
void flipT1()
{
    // do something!
    led2 = !led2;
    
    // clear the TIMER2 interrupt
    LPC_TIM1->IR = 1;
}

int main()
{
    volatile int i;
    volatile int j;
    int res;
    unsigned long rdata;
    unsigned long gdata;
    unsigned long bdata;
    char tmp[255];
    char filename[99];

    printf("[%s]\r\n", VERSION);

    nowCount = 0;
    fileCnt = 0;
    rxCnt = -1;
    rxFlag = 0;
    rxDataFlag = 0;
    tflag = 1;
    cmd = 0x00;
    rotIndex = 0;
    rotCntX = 0;
    rotCntY = 0;
    rotY = 0;
    rotSpeed = 40;
    rotStop = 1;
    offlineCnt = 0;
    offlineColor = 0;
    for (i = 0; i < RX_SIZE; i++) {
        rxStrR[i] = 0;
        rxStrG[i] = 0;
        rxStrB[i] = 0;
    }
    for (i = 0; i < W_DOT; i++) {
        rxLEDR[i] = 0;
        rxLEDG[i] = 0;
        rxLEDB[i] = 0;
    }

    timer0_init();
    timer1_init();
    // hang around!   
    while(1) {
        led4 = 1;
        wait(0.2);
        led4 = 0;
        wait(0.2);
    }
}
