#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

EthernetInterface eth;
HTTPClient http;

DigitalOut myled(LED2);

char str[512];

const char *url = "http://developer.mbed.org/media/uploads/planglois/index.html";

int main()
{
  int r = 0;
  int flash = 0;
  myled = 0;

  eth.init();
  eth.connect();

  while (true) {
    r = http.get(url, str, 32);

    if (r > 0) {
      std::printf("Error %d - HTTP return code %d\n", r, http.getHTTPResponseCode());
      goto fail;
    }

    flash = std::atoi(str);

    for (int i = 0; i < flash; i++) {
      myled = 1;
      wait(0.1);
      myled = 0;
      wait(0.1);
    }

    wait(1.0);
  }

fail:
  eth.disconnect();

  while(1) {}
}