#include "mbed.h"
#include "Thingspeak.h"
#include "ESP8266.h"
#include <string>

/*============================================================================*/
/* (a) MACRO and Constants declaration section                                           */
/*============================================================================*/
#define APIKEY NS64DJVP5YJKXUW2    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "Z"
#define WIFI_PASS "12345678"

/*============================================================================*/
/* (b) Variable declaration section                                           */
/*============================================================================*/
Serial pc(USBTX,USBRX);
ESP8266 esp(PTC17, PTC16, 115200); // baud rate for wifi

/** snd= string used to send command to ESP 8266 wifi
*   and  rcv = string used to receive response from ESP8266 wifi module
**/
char snd[255],rcv[1000],snd_Data[255],ip[100],connection[100];  
          
/*============================================================================*/
/* (c) Function definition section                                           */
/*============================================================================*/

/*!
 * Function used to initialize ESP8266 wifi module 
 * =============================================================================
 */
void Esp8266_Init ( void )
{    
    /* Baud rate used for communicating with Tera-term on PC */
    pc.baud(115200);
    pc.printf("\n\n\rInitializing ESP\n\n\r"); 
    //RESET ESP
    pc.printf("\n\n\rReset ESP\n\n\r"); 
    esp.Reset();
    /* Wait for 2 seconds */        
    wait(2);      
    pc.printf("\n\n\rSending AT command\n\n\r");
    strcpy(snd,"AT");
    esp.SendCMD(snd);     
    wait(0.1);
    pc.printf("\n\n\rSetting mode\n\n\r");
    esp.SetMode(1);
    wait(2);
    pc.printf("\n\n\rConnecting to wifi network\n\n\r");
    esp.Join(WIFI_SSID, WIFI_PASS);
    wait(5);
    // Set single connection
    esp.SetSingle();
    pc.printf("\n\n\rGetting IP\n\n\r");
    esp.GetIP(&ip[0]);
    pc.printf(ip);
    //receive a response from ESP
    pc.printf("\n\n\rReading connection status\n\n\r");
    esp.GetConnStatus(&connection[0]); 
    pc.printf(connection);
} 


/*!
 * Function used to connect with thingspeak.com and update channel using 
 * ESP8266 wifi module
 * =============================================================================
 */
void Send_to_Thingspeak ( int field1, int field2, int field3 )
{
    /* ESP updates the Status of Thingspeak channel */
    esp.startTCPConn(IP,80);
    wait(1);
    sprintf(snd,"GET https://api.thingspeak.com/update?api_key=NS64DJVP5YJKXUW2&field1=+%d+&field2=+%d+&field3=+%d+\r\n",field1, field2, field3);
    
    int i=0;
    for(i=0;snd[i]!='\0';i++);
    i++;
    char cmd[255];
    //Send Number of open connection and Characters to send 
    sprintf(cmd,"AT+CIPSEND=%d",i);                                       
    esp.SendCMD(cmd);
    pc.printf("S\r\n%s",cmd);
    while(i<=20 || rcv == ">")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    //Post value to thingspeak channel
    esp.SendCMD(snd);                                                      

    while(i<=20 || rcv == "OK")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
}

/*!
 * Function used to Read door status from Thingspeak channel 
 * 
 * =============================================================================
 */
int Read_from_Thingspeak ( void )
{
    char *prevPointer = NULL;
    char *currPointer = NULL;
    int doorCommand = 0xFF;
    
    /*Read door status from Thingspeak channel*/
    esp.startTCPConn(IP,80);
    wait(1);
    sprintf(snd,"GET https://api.thingspeak.com/channels/1309755/fields/1.json?api_key=F2HR03LUWEXO3QO0&results=2\r\n");
    
    int i=0;
    for(i=0;snd[i]!='\0';i++);
    i++;
    char cmd[255];
    //Send Number of open connection and Characters to send
    sprintf(cmd,"AT+CIPSEND=%d",i);                                        
    esp.SendCMD(cmd);
    pc.printf("S\r\n%s",cmd);
    while(i<=20 || rcv == ">")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    //Post value to thingspeak channel
    esp.SendCMD(snd);                                                      
    pc.printf("S\r\n%s",snd);
    
    while(i<=20 || rcv == "OK")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    esp.RcvReply(rcv, 1000);
    if(strstr(rcv,"field1") != NULL)
    {
        prevPointer = strstr(rcv,"field1");
        currPointer = strstr(rcv,"field1");
        if(strstr((currPointer + 6),"field1") != NULL)
        {
            currPointer = strstr((currPointer + 6),"field1"); 
            doorCommand = *(currPointer+9);
        }
        else
        {
            doorCommand = *(prevPointer+9);
        }
        //printf("word found\n\r");
    }
    pc.printf("R\r\n%s",rcv);
    
    return ( doorCommand - 48 );
}
