 //ECE 4180 Mini Project
//Prachi Kulkarni and Kendra Dodson

// This code is for Player 1

#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"

//Leds to show status of sending and receiving messages
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

//SD Card Reader
SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut DACout(p18);
wave_player waver(&DACout); // Wave Player

uLCD_4DGL lcd(p28, p27, p29); //uLCD
DigitalIn pb1(p17); //Pushbutton 1 - Rock
DigitalIn pb2(p19); //Pushbutton 2 - Paper 
DigitalIn pb3(p20); //Pushbutton 3 - Scissors

//Shiftbrite
DigitalOut latch(p15);
DigitalOut enable(p16);
SPI spi(p11, p12, p13);

//Choice
//Choice = 1 for rock
//Choice = 2 for paper
//Choice = 3 for scissors
char choice1; //Player 1's choice
char choice2; //Player 2's choice

//Points
int p1 = 0; //Player 1's points
int p2 = 0; //Player 2's points

//RGB function for Shiftbrite
void RGB_LED(int red, int green, int blue);
void RGB_LED(int red, int green, int blue)
{
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}
int i;

//Serial
Serial player1(p9,p10);

int main() {
    
    //Serial
    player1.baud(9600);
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    pb1.mode(PullUp);
    wait(0.001);
    pb2.mode(PullUp);
    wait(0.001);
    pb3.mode(PullUp);
    wait(0.001);
    
    //Display 
    lcd.locate(1,2);
    //Screen 1 shows the name of the game
    lcd.rectangle(0,0,125,125,WHITE); //Draw white border
    lcd.color(BLUE); //Set font color to blue
    lcd.text_bold(ON); //Bold the text
    lcd.text_width(2);
    lcd.text_height(2);
    lcd.printf("  Rock\n");
    lcd.printf("  Paper\n\n");
    lcd.printf(" Scissor\n\n");
    wait(5);
    
    //Screen 2 shows pushbutton options
    L1:
    lcd.cls();
    lcd.rectangle(0,0,125,125,WHITE); //Draw white border
    lcd.color(GREEN); //Set font color to green
    lcd.locate(0,2);
    lcd.printf(" Button Options\n\n");
    lcd.locate(0,5);
    lcd.text_underline(OFF);
    lcd.printf("  1 for Rocks");
    lcd.locate(0,7);
    lcd.printf("  2 for Paper");
    lcd.locate(0,9);
    lcd.printf("  3 for Scissors\n\n\n");
    lcd.text_bold(ON); //Bold the text
    lcd.printf(" Press 1 to start!");
    wait(1);
    
    while(1){
    //If push button 1 is pressed, start the game!
    if(pb1 != 1){
        
        //Play button select
            FILE *wave_file;
             printf("\n\n\nHello, wave world!\n");
            wave_file=fopen("/sd/select.wav","r");
            waver.play(wave_file);
            wait(1);
            printf("ok!!");
            fclose(wave_file);
            
    L3:
    lcd.cls(); //Clear screen
    lcd.rectangle(0,0,125,125,WHITE); //Draw white border
    //Tell player 1 that she/he has 5 seconds to chose between rock,paper and scissors
    lcd.locate(0,4);
    lcd.color(BLUE); //Set font color to yellow
    lcd.printf("     Player 1 \n\n\n");
    lcd.locate(0,6);
    lcd.color(GREEN); //Set font color to green
    lcd.printf("You have 5 seconds");
    lcd.printf("    to choose\n");
    lcd.printf("    an option!\n");
    wait(5);
    

    //Start timer for 5 seconds
    i = 5;;
    int red = 1;
    //for(i = 5; i > -1 ; i--){
        while(i > -1){
        
        lcd.cls();
        lcd.locate(4,4); //Place text in the center of the screen
        lcd.text_width(8); //Set tet width
        lcd.text_height(8); //Set text height
        lcd.text_bold(ON); //Set text style to 'bold'
        RGB_LED(red*25,0,0);//Increase intensity of light on shiftbrite as time decreases
        red = red + 5;
        lcd.printf("%d",i); //Display time left on LCD
        wait(1);
        
        //Press pushbutton 1 to choose rock
        if(pb1 != 1) {
            
            lcd.cls();
            choice1 = 'R';
            lcd.rectangle(0,0,125,125,WHITE); //Draw white border
            lcd.locate(0,1);
            lcd.printf("  You chose rock");
            
             //Play button select
            FILE *wave_file;
             printf("\n\n\nHello, wave world!\n");
            wave_file=fopen("/sd/mydir/select.wav","r");
            waver.play(wave_file);
            wait(1);
            printf("ok!!");
            fclose(wave_file);
            
            lcd.circle(60, 60, 30,WHITE);
            wait(3);
            lcd.cls();
            break;
        }
        //Press pushbutton 2 to choose paper
         else if(pb2 != 1) {
            lcd.cls();
            choice1 = 'P';
            lcd.rectangle(0,0,125,125,WHITE); //Draw white border
            
            lcd.locate(0,1);
            lcd.printf("  You chose paper");
            
             //Play button select
            FILE *wave_file;
             printf("\n\n\nHello, wave world!\n");
            wave_file=fopen("/sd/mydir/select.wav","r");
            waver.play(wave_file);
          
            printf("ok!!");
            fclose(wave_file);
            
            lcd.filled_rectangle(50, 45, 80,90,WHITE);
            wait(3);
            lcd.cls();
            break;
        }
        //Press pushbutton 3 to choose scissor
           else if(pb3 != 1) {
            lcd.cls();
            choice1 = 'S';
            lcd.rectangle(0,0,125,125,WHITE); //Draw white border
            lcd.locate(0,1);
            lcd.printf("You chose scissors");
            
            //Play button select
            FILE *wave_file;
             printf("\n\n\nHello, wave world!\n");
            wave_file=fopen("/sd/mydir/select.wav","r");
            waver.play(wave_file);
            wait(1);
            printf("ok!!");
            fclose(wave_file);
            lcd.circle(50, 60, 10,WHITE);
            lcd.circle(50, 80, 10,WHITE);
            lcd.line(62, 61, 90, 85, WHITE);
            lcd.line(62, 81, 90, 55, WHITE);
            wait(3);
            lcd.cls();
            break;
        }
        i--;
        
        }
        
        RGB_LED(0,0,0); // Reset shiftbrite color
        
 //-------------------------------------------------------------------------------------------------------------------------------------
 //                                          TIME-OUT
 //------------------------------------------------------------------------------------------------------------------------------------       
          
        //If user doesn't choose an option, show "Time Out" message and restart game
        if(i == -1){
            lcd.cls();
            lcd.rectangle(0,0,125,125,WHITE); //Draw white border
            lcd.locate(0,5);
            lcd.color(RED);
            lcd.printf(" Your time is up!"); 
            lcd.color(GREEN);
              //Play time up tune
            FILE *wave_file;
             printf("\n\n\nHello, wave world!\n");
            wave_file=fopen("/sd/mydir/timeup.wav","r");
            waver.play(wave_file);
            
            printf("ok!!");
            fclose(wave_file);
            wait(3);
            goto L1; //Starts the game again
            }  
            
 //--------------------------------------------------------------------------------------------------------------------------------------           
    
    //Send Player 1's choice to Player 2
    player1.printf("%c",choice1);
    myled2 = 1;
    wait(1);
    
    //Receive Player 2's choice
    while(1){
    lcd.locate(1,4);
    lcd.printf("  Waiting for \n the other player");    
    if(player1.readable()){
        choice2 = player1.getc();
        myled = 1;
        break;
        } 
        }
    
    
//-------------------------------------------------------------------------------------------------------------------------------------    
        //Check to see who won
//--------------------------------------------------------------------------------------------------------------------------        
        //Case 1 : Both players choose same option        
        if(choice1 == 'R' && choice2 == 'R' ||
            choice1== 'P' && choice2 == 'P' || 
            choice1 == 'S' && choice2 == 'S' ) {
                lcd.cls();
                lcd.rectangle(0,0,125,125,WHITE); //Draw white border
                lcd.locate(1,2);
                lcd.printf("  It's a draw!");
                wait(4);

                }
          //Case 2:
          //Player 1 : Rock
          //Player 2 : Paper      
          else if(choice1 == 'R' && choice2 == 'P'){
              
                lcd.cls();
                lcd.rectangle(0,0,125,125,WHITE); //Draw white border
                
                lcd.locate(1,2);
                lcd.printf(" P1 chose Rock\n");
                lcd.printf("  P2 chose Paper\n\n\n\n");
                lcd.locate(1,5);
                lcd.printf(" Player 2 wins!");
                lcd.filled_rectangle(50, 60, 80,90,WHITE);
                p2++;
                wait(4);

               }
           //Case 3:
          //Player 1 : Paper
          //Player 2 : Rock
            else if(choice2== 'P' && choice1== 'R'){
              
                lcd.cls();
                lcd.rectangle(0,0,125,125,WHITE); //Draw white border
                lcd.locate(1,2);
                lcd.printf("P1 chose Paper\n");
                lcd.printf(" P2 chose Rock\n\n");
                lcd.locate(1,5);
                lcd.printf("P1 wins!");
                lcd.filled_rectangle(50, 60, 80,90,WHITE);
                p1++;
                wait(5);

               }     
    
           //Case 4:
          //Player 1 : Paper
          //Player 2 : Scissor
    
            else if(choice1 == 'P' && choice2 == 'S'){
              
                lcd.cls();
                lcd.locate(1,1);
                lcd.printf("P1 chose Paper\n");
                lcd.printf(" P2 chose Scissors\n\n");
                lcd.locate(1,4);
                lcd.printf("P2 wins!");
                p2++;
                lcd.circle(50, 60, 10,WHITE);
                lcd.circle(50, 80, 10,WHITE);
                lcd.line(62, 61, 90, 85, WHITE);
                lcd.line(62, 81, 90, 55, WHITE);
                wait(5);

               }     
    //Case 5:
    //Player 1 : Scissor
    //Player 2 : Paper
    else if(choice1 == 'S' && choice2 == 'P'){
              
                lcd.cls();
                lcd.locate(1,1);
                lcd.printf("P1 chose Scissors\n");
                lcd.printf(" P2 chose Paper\n\n");
                lcd.locate(1,4);
                lcd.printf("P1 wins!");
                p1++;
                lcd.circle(50, 60, 10,WHITE);
                lcd.circle(50, 80, 10,WHITE);
                lcd.line(62, 61, 90, 85, WHITE);
                lcd.line(62, 81, 90, 55, WHITE);
                wait(5);
    
               }     
    //Case 6:
    //Player 1 : Rock
    //Player 2 : Scissors
    else if(choice1 == 'R' && choice2 == 'S'){
              
                lcd.cls();
                lcd.locate(1,1);
                lcd.printf("P1 chose Rock\n");
                lcd.printf(" P2 chose Scissors\n\n");
                lcd.locate(1,3);
                lcd.printf("P1 wins!");
                p1++;
                lcd.circle(60, 70, 30,WHITE);
                wait(5);
   
               }   
    //Case 7:
    //Player 1 : Scissors
    //Player 2 : Rock      
               
    else if(choice1 == 'S' && choice2 == 'R'){
              
                lcd.cls();
                lcd.locate(1,1);
                lcd.printf("P1 chose Scissors\n");
                lcd.printf(" P2 chose Rock\n\n");
                lcd.locate(1,3);
                lcd.printf("P2 wins!");
                p2++;
                lcd.circle(60, 70, 30,WHITE);
                wait(5);
             
               }     
    

                lcd.cls();
                lcd.locate(1,4);
                lcd.rectangle(0,0,125,125,WHITE); //Draw white border
                lcd.printf(" P1 Score : %d\n",p1);
                lcd.printf("  P2 Score : %d\n\n\n\n",p2);
                lcd.printf("  1 to continue\n\n");
                lcd.printf("  2 to end\n\n");
                
                char continue1 = 'N';
                char continue2;
                //char cont;
                
                
                while(1){
                    if(pb1 != 1) {
                        lcd.cls();
                        continue1 = 'Y';
                        break;
                        //goto L3;
                    }
                    else if(pb2 != 1) {
                        lcd.cls();
                        continue1 = 'N';
                        break;
                        }
                }
                
                
                    player1.printf("%c",continue1);
                    myled3 = 1;
                    wait(1);
                    
                    while(1){
                    lcd.locate(1,4);
                    lcd.printf("  Waiting for \n the other player");     
                    if(player1.readable()){
                        continue2 = player1.getc();
                        myled = 1;
                        break;
                        } 
                        }
                
                //If both say continue then you need to go back to L3
                if(continue1 == 'Y' && continue2 == 'Y') goto L3;
                else goto L2;
 }}

    



//If game ends :
L2:
                        lcd.cls();
                        //Create animation of two bouncing balls
                        float fx=50.0,fy=21.0,vx=5.0,vy=0.4,vx2=2,fx2=40.0;
                        int x=50,y=21,radius=4;
                        int x2 = 30, y2 = 10;
                        
                        //draw walls
                        wait(2);
                        //If Player 1's score is higher than Player 2's score
                        if(p1 > p2) 
                        //lcd.printf("Player 1 wins!");
                        lcd.text_string("Player 1 Wins!", 2, 4, FONT_7X8, WHITE);
                        //If Player 1's score is equal to Player 2's score
                        else if(p1 == p2) 
                        //lcd.printf("It's a draw!");
                        lcd.text_string("It's a draw!", 2, 4, FONT_7X8, WHITE);
                        //If Player 2's score is higher than Player 1's score        
                        else if(p2 > p1) 
                        //lcd.printf("Player 2 wins!");
                       lcd.text_string("Player 2 Wins!", 2, 4, FONT_7X8, WHITE);
                       
                        // Play winning tune
                        FILE *wave_file;
                        printf("\n\n\nHello, wave world!\n");
                        wave_file=fopen("/sd/mydir/win.wav","r");
                        waver.play(wave_file);
                     
                        printf("ok!!");
                        fclose(wave_file);
                       
                            for (int i=0; i<100; i++) {
                                //draw ball
                                //lcd.cls();
                        if(p1 > p2) 
                        lcd.text_string("Player 1 Wins!", 2, 4, FONT_7X8, WHITE);
                        
                        else if(p1 == p2) 
                      lcd.text_string("It's a draw!", 2, 4, FONT_7X8, WHITE);
                                
                        else if(p2 > p1) 
                        lcd.text_string("Player 2 Wins!", 2, 4, FONT_7X8, WHITE);
                                
                                lcd.filled_circle(x, y, radius, RED);
                                lcd.filled_circle(x2,y2,radius,BLUE);
                                RGB_LED(x,y,x);
                                //bounce off edge walls and slow down a bit
                                if ((x<=radius+1) || (x>=126-radius)) vx = -.90*vx;
                                if ((y<=radius+1) || (y>=126-radius)) vy = -.90*vy;
                                if ((x2<=radius+1) || (x2>=126-radius)) vx2 = -.90*vx2;
                                if ((y2<=radius+1) || (y2>=126-radius)) vy = -.90*vy;
                                //erase old ball location
                                lcd.filled_circle(x, y, radius, BLACK);
                                lcd.filled_circle(x2, y2, radius, BLACK);
                                //move ball
                                fx=fx+vx;
                                fx2=fx2+vx2;
                                fy=fy+vy;
                                x=(int)fx;
                                y=(int)fy;
                                x2=(int)fx2;
                                y2=(int)fy;
                                }
lcd.cls();                            

}