#include "LM75B.h"
#include "MMA7660.h"

#include "APPLICATION.h"
#include "PAGE.h"
#include "WEB.h"

#include "ESP-call.h"

// Values define =========================================================================================================

LM75B temp(D14, D15);
Thread _application;
char ledState[11] = "Device";
char ledColor[11] = " ";

// Functions prototype =========================================================================================================

void ledChangeColor(unsigned short i);
void wifiInitValues(void);
void application(void);

// Main function =========================================================================================================

int main()
{
    applicationInit();
    lcdShowInitDevicePage(1);


    lcdShowTryToConnectPage(1);
    lcdShowLoadingSimbolStart(0, 20);
    wifiConnectToAP();
    wifiGetIpAddress();
    lcdShowLoadingSimbolTerminate();

    _lcd.cls();
    _lcd.locate(0, 0);
    _lcd.printf("Generating web site");
    lcdShowMyIPPage(0);
    lcdShowLoadingSimbolStart(0, 20);
    wifiInitValues();
    webCreateHtmlDoc();
    webDisplayWebsite();
    wifiInitServer();
    timerInit();
    lcdShowLoadingSimbolTerminate();

    _lcd.cls();
    _application.start(application);

    wifiInitReceiveData();
    while(true) {
    }

}

// Functions define =========================================================================================================

void application(void)
{
    while (true) {
        float temperature = temp.read();
        lcdShowMyIPPage(0);

        semaphoreTimer.acquire();
        lcdShowDaytime(0);
        wifiGenerateValueI("timeHour", timerHour);
        wifiGenerateValueI("timeMinute", timerMinute);
        wifiGenerateValueI("timeSecond", timerSecond);
        semaphoreTimer.release();

        semaphoreAlarmData.acquire();
        lcdShowAlerttime(0);
        wifiGenerateValueI("alarmHour", alarmHour);
        wifiGenerateValueI("alarmMinute", alarmMinute);
        wifiGenerateValueI("alarmSecond", alarmSecond);
        semaphoreAlarmData.release();

        wifiGenerateValueF("temperature", temperature);
        wifiGenerateValueS("temperatureUnit", "C");

        wifiGenerateValueS("ledState", ledState);
        wifiGenerateValueS("ledColor", ledColor);

        semaphoreModify.acquire();
        _lcd.locate(0, 0);
        if(MODE_MODIFY_TIME == UNABLE_TO_MODIFY_TIME) {
            semaphoreModify.release();
            _lcd.characterI(0, 0, 'T');
            wifiGenerateValueS("timeState", "Fixed");
        } else {
            semaphoreModify.release();
            _lcd.putc('T');
            wifiGenerateValueS("timeState", "Changeable");
        }


        semaphoreAlarmData.acquire();
        _lcd.locate(9, 0);
        if(alarmState == ALARM_ENABLED) {
            semaphoreAlarmData.release();
            _lcd.putc('A');
            wifiGenerateValueS("alarmState", "Enabled");
        } else {
            semaphoreAlarmData.release();
            _lcd.characterI(9, 0, 'A');
            wifiGenerateValueS("alarmState", "Disabled");
        }
        semaphoreAlarmData.release();
        ledChangeColor(potValueU16(POT_LEFT));
        _lcd.locate(60, 0);
        _lcd.printf("%.2fC", temperature);
        thread_sleep_for(100);
    }
}

void wifiInitValues(void)
{
    wifiGenerateValueS("timeState", " ");
    wifiGenerateValueI("timeHour", 0);
    wifiGenerateValueI("timeMinute", 12);
    wifiGenerateValueI("timeSecond", 20);

    wifiGenerateValueS("alarmState", " ");
    wifiGenerateValueI("alarmHour", 0);
    wifiGenerateValueI("alarmMinute", 12);
    wifiGenerateValueI("alarmSecond", 20);

    wifiGenerateValueF("temperature", 0.0);
    wifiGenerateValueS("temperatureUnit", "C");

    wifiGenerateValueS("ledState", " ");
    wifiGenerateValueS("ledColor", " ");
}


void ledChangeColor(unsigned short i)
{
    strcpy(ledState, "Device");
    if(0 <= i && i < 0xFFFF / 8) {
        ledSetColor(0, 0, 0);
        strcpy(ledColor, "Black");
    } else if(0xFFFF / 8 <= i && i < (0xFFFF / 8) * 2) {
        ledSetColor(1, 0, 0);
        strcpy(ledColor, "Red");
    } else if((0xFFFF / 8) * 2 <= i && i < (0xFFFF / 8) * 3) {
        ledSetColor(0, 1, 0);
        strcpy(ledColor, "Lime");
    } else if((0xFFFF / 8) * 3 <= i && i < (0xFFFF / 8) * 4) {
        ledSetColor(0, 0, 1);
        strcpy(ledColor, "Blue");
    } else if((0xFFFF / 8) * 4 <= i && i < (0xFFFF / 8) * 5) {
        ledSetColor(1, 1, 0);
        strcpy(ledColor, "Yellow");
    } else if((0xFFFF / 8) * 5 <= i && i < (0xFFFF / 8) * 6) {
        ledSetColor(0, 1, 1);
        strcpy(ledColor, "Cyan");
    } else if((0xFFFF / 8) * 6 <= i && i < (0xFFFF / 8) * 7) {
        ledSetColor(1, 0, 1);
        strcpy(ledColor, "Fuchsia");
    } else if((0xFFFF / 8) * 7 <= i && i <= (0xFFFF / 8) * 8) {
        ledSetColor(1, 1, 1);
        strcpy(ledColor, "White");
    }
}


