#ifndef _WIFI_H
#define _WIFI_H

#include "mbed.h"
#include "ESP-call.h"

extern char wifiIpAddress[16];
extern char wifiSSID[1025];
extern char wifiSSIDPassword[1025];
extern volatile char wifiReceivedBuffer[2049];
extern Semaphore semaphoreWifiHasBuffer;

void wifiInit(void);
void wifiConnectToAP(void);
char* wifiGetIpAddress(void);
void wifiInitServer(void);
void wifiGenerateValueI(const char *value, int data);
void wifiGenerateValueF(const char *value, float data);
void wifiGenerateValueS(const char *value, const char *data);
void wifiGenerateValueS(const char *value, char data[]);
void wifiInitReceiveData(void);


#endif