#include "WIFI.h"

char wifiIpAddress[16] = {0,};
char wifiSSID[1025] = "fig";
char wifiSSIDPassword[1025] = "10281028";
volatile char wifiReceivedBuffer[2049] = {0};
volatile int wifiReceivedBufferIndex = 0;

Semaphore semaphoreWifiHasBuffer(0, 1);

void wifiInit(void)
{
    PC.baud(115200);
    ESP.baud(115200);
    PC.printf("\r\nReset ESP...\r\n");
    ESP_reset();
    PC.printf("Setup ESP noecho...\r\n");
    ESP_noecho();
}

void wifiConnectToAP(void)
{
    char wifiSSIDInstruction[1042];
    char wifiSSIDPasswordInstruction[1041];

    PC.printf("\r\nTry to connect to %s wifi!!\r\n", wifiSSID);

    sprintf(wifiSSIDInstruction, "station_cfg.ssid=\"%s\"", wifiSSID);
    sprintf(wifiSSIDPasswordInstruction, "station_cfg.pwd=\"%s\"", wifiSSIDPassword);

    NodeMCU_PGM wifiConnect[] = {
        "", 1,
        "wifi.setmode(wifi.STATION)", 1,
        "", 1,
        "station_cfg={}", 1,
        wifiSSIDInstruction, 1,
        wifiSSIDPasswordInstruction, 1,
        "station_cfg.save=false", 1,    //false
        "wifi.sta.config(station_cfg)", 1,
        "", 1,
        "wifi.sta.connect()", 80, // long delay here!
        NULL, 0,
    };

    ESP_call_multi(wifiConnect);
}

char* wifiGetIpAddress(void)
{
    NodeMCU_PGM wifiGetIpAddress[] = {
        "", 1,
        "print(wifi.sta.getip())", 1,
        NULL, 0,
    };

    ESP_call_multi(wifiGetIpAddress);

    char *pIp[2] = {ESP_recv_buffer, 0};

    /*
    ESP_recv_buffer 안에 저장된 xxx.xxx.xxx.xxx   yyy.yyy.yyy.yyy zzz.zzz.zzz중 xxx.xxx.xxx.xxx IP를 얻기 위해
    xxx.xxx.xxx.xxx가 시작하는 문자열 상의 주소와 끝나는 주소 값이 저장됩니다.
    즉 \t가 나올 때까지 검사합니다.
    */

    pIp[1] = strchr(pIp[0] + 1, '\t');

    int ipLength = pIp[1] - pIp[0];

    for(int i = 0; i < ipLength; i++) {
        wifiIpAddress[i] = *(pIp[0] + i);
    }

    PC.printf("\r\nYour IP: %s\r\n", wifiIpAddress);

    return wifiIpAddress;
}

void wifiInitServer(void)
{
    NodeMCU_PGM wifiServerCode[] = {
        "", 1,
        "http_resp = \"HTTP/1.0 200 OK\\r\\nContent-Type: text/html\\r\\n\\r\\n\"", 1,
        "srv = net.createServer(net.TCP)", 1,
        "srv:listen(80, function(conn)", 1,
        "   conn:on(\"receive\", function(sck, payload)", 1,
        "       if string.match(payload, \"NEW_ALARM_DATA\") then", 1,
        "           i, j = string.find(payload, \"NEW_ALARM_DATA\")", 1,
        "           i = i + 15", 1,
        "           j = j + 14", 1,
        "           print(\"@\"..string.sub(payload, i, j)..\"~\")", 1,
        "       end", 1,
        "       sck:send(http_resp)", 1,
        "       sck:send(htmlTag)", 1,
        "       sck:send(htmlOpenTag)", 1,
        "       sck:send(headOpenTag)", 1,
        "       sck:send(styleOpenTag)", 1,
        "       sck:send(styleTag)", 1,
        "       sck:send(styleCloseTag)", 1,
        "       sck:send(headTag)", 1,
        "       sck:send(headCloseTag)", 1,

        "       sck:send(bodyOpenTag)", 1,
        "       sck:send(divOpenTag)", 1,


        "       sck:send(brTags)", 1,
        "       sck:send(table1OpenTag)", 1,
        "       sck:send(table1HeadOpenTag)", 1,
        "       sck:send(table1HeadRow1Tag)", 1,
        "       sck:send(table1HeadRow2Tag)", 1,
        "       sck:send(table1HeadRow3Tag)", 1,
        "       sck:send(table1HeadCloseTag)", 1,

        "       sck:send(table1BodyOpenTag)", 1,
        "       sck:send(string.format(table1BodyRow1Tag, timeState, timeHour, timeMinute, timeSecond))", 1,
        "       sck:send(string.format(table1BodyRow2Tag, alarmState, alarmHour, alarmMinute, alarmSecond))", 1,
        "       sck:send(string.format(table1BodyRow3Tag, temperature, temperatureUnit))", 1,
        "       sck:send(string.format(table1BodyRow4Tag, ledState, ledColor))", 1,
        "       sck:send(table1BodyCloseTag)", 1,
        "       sck:send(table1CloseTag)", 1,

        "       sck:send(brTags)", 1,

        "       sck:send(table2OpenTag)", 1,
        "       sck:send(table2HeadOpenTag)", 1,
        "       sck:send(table2HeadRow1Tag)", 1,
        "       sck:send(table2HeadRow2Tag)", 1,
        "       sck:send(table2HeadRow3Tag)", 1,
        "       sck:send(table2HeadCloseTag)", 1,

        "       sck:send(table2BodyOpenTag)", 1,
//        "       sck:send(table2BodyRow1Tag)", 1,
//        "       sck:send(table2BodyRow2Tag)", 1,
        "       sck:send(table2BodyRow3Tag)", 1,
//        "       sck:send(table2BodyRow4Tag)", 1,
//        "       sck:send(table2BodyRow5Tag)", 1,
        "       sck:send(table2BodyCloseTag)", 1,
        "       sck:send(table2CloseTag)", 1,


        "       sck:send(divCloseTag)", 1,
        "       sck:send(bodyCloseTag)", 1,
        "       sck:send(htmlCloseTag)", 1,
        "       end)", 1,
        "   conn:on(\"sent\", function(sck) sck:close() end)", 1,
        "end)", 1,
        NULL, 0,
    };

    ESP_call_multi(wifiServerCode);
}

void wifiGenerateValueF(const char *value, float data)
{
    ESP.printf("%s = %f\r\n", value, data);
}

void wifiGenerateValueI(const char *value, int data)
{
    ESP.printf("%s = %d\r\n", value, data);
}

void wifiGenerateValueS(const char *value, const char *data)
{
    ESP.printf("%s = \"%s\"\r\n", value, data);
}

void wifiGenerateValueS(const char *value, char *data)
{
    ESP.printf("%s = \"%s\"\r\n", value, data);
}

void wifiReceiveData(void)
{
    int data = ESP.getc();
    if((data != ' ') && (data != '>')) {
        wifiReceivedBuffer[wifiReceivedBufferIndex++] = (char) data;
        if(data == '~') {
            wifiReceivedBuffer[wifiReceivedBufferIndex] = '\0';
            semaphoreWifiHasBuffer.release();
        }
    } else {
        wifiReceivedBuffer[0] = '\0';
        wifiReceivedBufferIndex = 0;
    }
}

void wifiInitReceiveData(void)
{
    ESP.attach(wifiReceiveData, Serial::RxIrq);
}