#include "WEB.h"

void webAddTag(const char *tagName, const char *tagMessage)
{
    PC.printf("%s = %s..\"%s\\r\\n\"\r\n", tagName, tagName, tagMessage);
    ESP_recv_buffer_index = 0;
    ESP.attach(&ISR_ESP_to_recv_buffer, Serial::RxIrq);

    ESP.printf("%s = %s..\"%s\\r\\n\"\r\n", tagName, tagName, tagMessage);

    thread_sleep_for((1) * 100);
    ESP.attach(NULL, Serial::RxIrq);
    ESP_recv_buffer[ESP_recv_buffer_index] = '\0';
    PC.printf("%s", ESP_recv_buffer);
}


void webCreateHtmlDoc(void)
{
    NodeMCU_PGM htmlTag[] = {
        "htmlTag = \"<!DOCTYPE html>\\r\\n\"", 1,
        "htmlOpenTag = \"<html>\\r\\n\"", 1,
        "headOpenTag = \"<head>\\r\\n\"", 1,
        "styleOpenTag = \"<style>\\r\\n\"", 1,
        "styleTag = \" \"", 1,
        "styleCloseTag = \"</style>\\r\\n\"", 1,
        "headTag = \" \"", 1,
        "headCloseTag = \"</head>\\r\\n\"", 1,
        "bodyOpenTag = \"<body>\\r\\n\"", 1,
        "divOpenTag = \"<div style=\\\"text-align:center\\\">\\r\\n\"", 1,
        "table1OpenTag = \"<table>\\r\\n\"", 1,
        "table1HeadOpenTag = \"<thead>\\r\\n\"", 1,
        "table1HeadRow1Tag = \" \"", 1,
        "table1HeadRow2Tag = \" \"", 1,
        "table1HeadRow3Tag = \" \"", 1,
        "table1HeadCloseTag = \"</thead>\\r\\n\"", 1,
        "table1BodyOpenTag = \"<tbody>\\r\\n\"", 1,
        "table1BodyRow1Tag = \" \"", 1,
        "table1BodyRow2Tag = \" \"", 1,
        "table1BodyRow3Tag = \" \"", 1,
        "table1BodyRow4Tag = \" \"", 1,
        "table1BodyCloseTag = \"</tbody>\\r\\n\"", 1,
        "table1CloseTag = \"<table>\\r\\n\"", 1,
        "brTags = \"<br><br><br><br><br><br><br><br><br>\"", 1,
        "table2OpenTag = \"<table>\\r\\n\"", 1,
        "table2HeadOpenTag = \"<thead>\\r\\n\"", 1,
        "table2HeadRow1Tag = \" \"", 1,
        "table2HeadRow2Tag = \" \"", 1,
        "table2HeadRow3Tag = \" \"", 1,
        "table2HeadCloseTag = \"</thead>\\r\\n\"", 1,
        "table2BodyOpenTag = \"<tbody>\\r\\n\"", 1,
        "table2BodyRow1Tag = \" \"", 1,
        "table2BodyRow2Tag = \" \"", 1,
        "table2BodyRow3Tag = \" \"", 1,
        "table2BodyRow4Tag = \" \"", 1,
        "table2BodyRow5Tag = \" \"", 1,
        "table2BodyCloseTag = \"</tbody>\\r\\n\"", 1,
        "table2CloseTag = \"<table>\\r\\n\"", 1,
        "divCloseTag = \"</div>\\r\\n\"", 1,
        "bodyCloseTag = \"</body>\\r\\n\"", 1,
        "htmlCloseTag = \"</html>\\r\\n\"", 1,
        NULL, 0,
    };
    ESP_call_multi(htmlTag);
}








void webDisplayWebsite(void)
{



    webAddTag("headTag", "<title> Embedded Project </title>");
    webAddTag("table1HeadRow1Tag", "<tr>");
    webAddTag("table1HeadRow1Tag", "<th colspan=\\\"3\\\" style=\\\"font-size: 2rem;\\\">Device Information</th>");
    webAddTag("table1HeadRow1Tag", "</tr>");

    webAddTag("table1HeadRow2Tag", "<tr>");
    webAddTag("table1HeadRow2Tag", "<th colspan=\\\"3\\\">");
    webAddTag("table1HeadRow2Tag", "<hr>");
    webAddTag("table1HeadRow2Tag", "</hr>");
    webAddTag("table1HeadRow2Tag", "</tr>");
    webAddTag("table1HeadRow2Tag", "</tr>");

    webAddTag("table1HeadRow3Tag", "<tr>");
    webAddTag("table1HeadRow3Tag", "<th>Device</th>");
    webAddTag("table1HeadRow3Tag", "<th>State</th>");
    webAddTag("table1HeadRow3Tag", "<th>Data</th>");
    webAddTag("table1HeadRow3Tag", "</tr>");





    webAddTag("table1BodyRow1Tag", "<tr>");
    webAddTag("table1BodyRow1Tag", "<th>Time </th>");
    webAddTag("table1BodyRow1Tag", "<td>%s</td>");
    webAddTag("table1BodyRow1Tag", "<td>%02d:%02d:%02d</td>");
    webAddTag("table1BodyRow1Tag", "</tr>");

    webAddTag("table1BodyRow2Tag", "<tr>");
    webAddTag("table1BodyRow2Tag", "<th>Alarm </th>");
    webAddTag("table1BodyRow2Tag", "<td>%s</td>");
    webAddTag("table1BodyRow2Tag", "<td>%02d:%02d:%02d</td>");
    webAddTag("table1BodyRow2Tag", "</tr>");

    webAddTag("table1BodyRow3Tag", "<tr>");
    webAddTag("table1BodyRow3Tag", "<th>Temperature </th>");
    webAddTag("table1BodyRow3Tag", "<td>Enabled</td>");
    webAddTag("table1BodyRow3Tag", "<td>%.2f %s</td>");
    webAddTag("table1BodyRow3Tag", "</tr>");

    webAddTag("table1BodyRow4Tag", "<tr>");
    webAddTag("table1BodyRow4Tag", "<th>LED </th>");
    webAddTag("table1BodyRow4Tag", "<td>Changed by %s</td>");
    webAddTag("table1BodyRow4Tag", "<td>");
    webAddTag("table1BodyRow4Tag", "<div class=\\\"colorBox\\\" style=\\\"margin-left: auto; margin-right: auto; background: %s;\\\"></div>");
    webAddTag("table1BodyRow4Tag", "</td>");
    webAddTag("table1BodyRow4Tag", "</tr>");






    webAddTag("table2HeadRow1Tag", "<tr>");
    webAddTag("table2HeadRow1Tag", "<th colspan=\\\"4\\\" style=\\\"font-size: 2rem;\\\">Device Change</th>");
    webAddTag("table2HeadRow1Tag", "</tr>");

    webAddTag("table2HeadRow2Tag", "<tr>");
    webAddTag("table2HeadRow2Tag", "<th colspan=\\\"4\\\">");
    webAddTag("table2HeadRow2Tag", "<hr>");
    webAddTag("table2HeadRow2Tag", "</hr>");
    webAddTag("table2HeadRow2Tag", "</th>");
    webAddTag("table2HeadRow2Tag", "</tr>");

    webAddTag("table2HeadRow3Tag", "<tr>");
    webAddTag("table2HeadRow3Tag", "<th>Device</th>");
    /*    webAddTag("table2HeadRow3Tag", "<th>Enable change</th>");*/
    webAddTag("table2HeadRow3Tag", "<th>New data</th>");
    webAddTag("table2HeadRow3Tag", "<th>Submit</th>");
    webAddTag("table2HeadRow3Tag", "</tr>");
    webAddTag("table2HeadRow3Tag", "<tr>");

    /*    webAddTag("table2BodyRow1Tag", "<tr>");
        webAddTag("table2BodyRow1Tag", "<th>Time</th>");
        webAddTag("table2BodyRow1Tag", "<td>");
        webAddTag("table2BodyRow1Tag", "<label class=\\\"switch\\\">");
        webAddTag("table2BodyRow1Tag", "<input type=\\\"checkbox\\\" name=\\\"MODE_MODIFY_TIME\\\">");
        webAddTag("table2BodyRow1Tag", "<span class=\\\"slider round\\\"></span>");
        webAddTag("table2BodyRow1Tag", "</label>");
        webAddTag("table2BodyRow1Tag", "</td>");
        webAddTag("table2BodyRow1Tag", "<td>");
        webAddTag("table2BodyRow1Tag", "<input type=\\\"text\\\" style=\\\"width:5rem;\\\" id=\\\"ID_NEW_TIME_DATA\\\" name=\\\"NEW_TIME_DATA\\\" placeholder=\\\"12:00:00\\\" pattern=\\\"[0-2]{1}[0-9]{1}:[0-5]{1}[0-9]{1}:[0-5]{1}[0-9]{1}\\\" title=\\\"ex) 00:12:20\\\" required>");
        webAddTag("table2BodyRow1Tag", "</td>");
        webAddTag("table2BodyRow1Tag", "<td><input type=\\\"submit\\\"></input></td>");
        webAddTag("table2BodyRow1Tag", "</tr>");*/

    /*    webAddTag("table2BodyRow2Tag", "<tr>");
        webAddTag("table2BodyRow2Tag", "<tr>");
        webAddTag("table2BodyRow2Tag", "<tr>");
        webAddTag("table2BodyRow2Tag", "<th>Alarm enable</th>");
        webAddTag("table2BodyRow2Tag", "<td>");
        webAddTag("table2BodyRow2Tag", "<label class=\\\"switch\\\">");
        webAddTag("table2BodyRow2Tag", "<input type=\\\"checkbox\\\" name=\\\"MODE_MODIFY_ALARM_STATE\\\"></input>");
        webAddTag("table2BodyRow2Tag", "<span class=\\\"slider round\\\"></span>");
        webAddTag("table2BodyRow2Tag", "</label>");
        webAddTag("table2BodyRow2Tag", "</td>");
        webAddTag("table2BodyRow2Tag", "<td>");
        webAddTag("table2BodyRow2Tag", "<label class=\\\"switch\\\">");
        webAddTag("table2BodyRow2Tag", "<input type=\\\"checkbox\\\" name=\\\"MODE_MODIFY_ALARM_ENABLE_STATE\\\">");
        webAddTag("table2BodyRow2Tag", "<span class=\\\"slider round\\\"></span>");
        webAddTag("table2BodyRow2Tag", "</label>");
        webAddTag("table2BodyRow2Tag", "</td>");
        webAddTag("table2BodyRow2Tag", "<td>");
        webAddTag("table2BodyRow2Tag", "<input type=\\\"submit\\\">");
        webAddTag("table2BodyRow2Tag", "</td>");
        webAddTag("table2BodyRow2Tag", "</tr>");*/


    webAddTag("table2BodyRow3Tag", "<tr>");
    webAddTag("table2BodyRow3Tag", "<th>Alarm</th>");
    webAddTag("table2BodyRow3Tag", "<form name=\\\"text\\\" method=\\\"POST\\\">");
    /*    webAddTag("table2BodyRow3Tag", "<td>");
        webAddTag("table2BodyRow3Tag", "<label class=\\\"switch\\\">");
        webAddTag("table2BodyRow3Tag", "<input type=\\\"checkbox\\\" name=\\\"MODE_MODIFY_ALARM_TIME\\\">");
        webAddTag("table2BodyRow3Tag", "<span class=\\\"slider round\\\"></span>");
        webAddTag("table2BodyRow3Tag", "</label>");
        webAddTag("table2BodyRow3Tag", "</td>");*/
    webAddTag("table2BodyRow3Tag", "<td>");
    webAddTag("table2BodyRow3Tag", "<input type=\\\"text\\\" style=\\\"width:5rem;\\\" id=\\\"ID_NEW_ALARM\\\" name=\\\"NEW_ALARM_DATA\\\" placeholder=\\\"12:00:00\\\" pattern=\\\"[0-2]{1}[0-9]{1}:[0-5]{1}[0-9]{1}:[0-5]{1}[0-9]{1}\\\" title=\\\"ex) 00:12:20\\\" required>");
    webAddTag("table2BodyRow3Tag", "</td>");
    webAddTag("table2BodyRow3Tag", "<td>");
    webAddTag("table2BodyRow3Tag", "<input type=\\\"submit\\\"></input>");
    webAddTag("table2BodyRow3Tag", "</td>");
    webAddTag("table2BodyRow3Tag", "</form>");
    webAddTag("table2BodyRow3Tag", "</tr>");


    /*    webAddTag("table2BodyRow4Tag", "<tr>");
        webAddTag("table2BodyRow4Tag", "<th>Temperature unit</th>");
        webAddTag("table2BodyRow4Tag", "<td>");
        webAddTag("table2BodyRow4Tag", "<label class=\\\"switch\\\">");
        webAddTag("table2BodyRow4Tag", "<input type=\\\"checkbox\\\" name=\\\"MODE_MODIFY_TEMPERATURE_UNIT\\\">");
        webAddTag("table2BodyRow4Tag", "<span class=\\\"slider round\\\"></span>");
        webAddTag("table2BodyRow4Tag", "</label>");
        webAddTag("table2BodyRow4Tag", "</td>");
        webAddTag("table2BodyRow4Tag", "<td>");
        webAddTag("table2BodyRow4Tag", "C");
        webAddTag("table2BodyRow4Tag", "<label class=\\\"switch\\\">");
        webAddTag("table2BodyRow4Tag", "<input type=\\\"checkbox\\\" name=\\\"TEMPERATURE_UNIT\\\">");
        webAddTag("table2BodyRow4Tag", "<span class=\\\"slider round\\\"></span>");
        webAddTag("table2BodyRow4Tag", "</label>");
        webAddTag("table2BodyRow4Tag", "F");
        webAddTag("table2BodyRow4Tag", "</td>");
        webAddTag("table2BodyRow4Tag", "<td><input type=\\\"submit\\\"></input></td>");
        webAddTag("table2BodyRow4Tag", "</tr>");*/

    /*    webAddTag("table2BodyRow5Tag", "<tr>");
        webAddTag("table2BodyRow5Tag", "<th>LED color</th>");
        webAddTag("table2BodyRow5Tag", "<td>");
        webAddTag("table2BodyRow5Tag", "<label class=\\\"switch\\\">");
        webAddTag("table2BodyRow5Tag", "<input type=\\\"checkbox\\\" name=\\\"MODE_MODIFY_LED_COLOR\\\">");
        webAddTag("table2BodyRow5Tag", "<span class=\\\"slider round\\\"></span>");
        webAddTag("table2BodyRow5Tag", "</label>");
        webAddTag("table2BodyRow5Tag", "</td>");
        webAddTag("table2BodyRow5Tag", "<td>");
        webAddTag("table2BodyRow5Tag", "<select name=\\\"LED_COLOR\\\">");
        webAddTag("table2BodyRow5Tag", "<option value=\\\"0\\\" selected>Black</option>");
        webAddTag("table2BodyRow5Tag", "<option value=\\\"1\\\">Red</option>");
        webAddTag("table2BodyRow5Tag", "<option value=\\\"2\\\">Green</option>");
        webAddTag("table2BodyRow5Tag", "<option value=\\\"3\\\">Blue</option>");
        webAddTag("table2BodyRow5Tag", "<option value=\\\"4\\\">Yellow</option>");
        webAddTag("table2BodyRow5Tag", "<option value=\\\"5\\\">Turquoise</option>");
        webAddTag("table2BodyRow5Tag", "<option value=\\\"6\\\">Purple</option>");
        webAddTag("table2BodyRow5Tag", "<option value=\\\"7\\\">White</option>");
        webAddTag("table2BodyRow5Tag", "</select>");
        webAddTag("table2BodyRow5Tag", "</td>");
        webAddTag("table2BodyRow5Tag", "<td><input type=\\\"submit\\\"></input></td>");
        webAddTag("table2BodyRow5Tag", "</tr>");*/



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    webAddTag("styleTag","body {");
    webAddTag("styleTag","   width: 70%;");
    webAddTag("styleTag","   margin-left: auto;");
    webAddTag("styleTag", "    margin-right: auto;");
    webAddTag("styleTag", "}");

    /*webAddTag("styleTag", ".title-hr {");
    webAddTag("styleTag", "   border-top: 0.05em solid rgb(180,180,180);");
    webAddTag("styleTag", "   line-height: 1em;");
    webAddTag("styleTag", "   position: relative; ");
    webAddTag("styleTag", "   text-align: center; ");
    webAddTag("styleTag", "   color: black; ");
    webAddTag("styleTag", "}");*/

    /*webAddTag("styleTag", ".switch {");
    webAddTag("styleTag", "   position: relative;");
    webAddTag("styleTag", "   display: inline-block; ");
    webAddTag("styleTag", "    width: 50px;");
    webAddTag("styleTag", "    height: 26px; ");
    webAddTag("styleTag", "}");
    webAddTag("styleTag", ".switch input {");
    webAddTag("styleTag", "    opacity: 0;");
    webAddTag("styleTag", "    width: 0; ");
    webAddTag("styleTag", "    height: 0;");
    webAddTag("styleTag", "}");*/

    /*webAddTag("styleTag", ".slider {");
    webAddTag("styleTag", "   position: absolute;");
    webAddTag("styleTag", "   cursor: pointer; ");
    webAddTag("styleTag", "   top: 0;");
    webAddTag("styleTag", "   left: 0; ");
    webAddTag("styleTag", "   right: 0;");
    webAddTag("styleTag", "   bottom: 0; ");
    webAddTag("styleTag", "   background-color: rgb(180,180,180);");
    webAddTag("styleTag", "   -webkit-transition: .4s; ");
    webAddTag("styleTag", "   transition: .4s;");
    webAddTag("styleTag", "}");

    webAddTag("styleTag", ".slider:before {");
    webAddTag("styleTag", "   position: absolute;");
    webAddTag("styleTag", "   content: \\\"\\\";");
    webAddTag("styleTag", "   height: 18px; ");
    webAddTag("styleTag", "   width: 18px;");
    webAddTag("styleTag", "   left: 4px; ");
    webAddTag("styleTag", "   bottom: 4px;");
    webAddTag("styleTag", "   background-color: white; ");
    webAddTag("styleTag", "   -webkit-transition: .4s;");
    webAddTag("styleTag", "   transition: .4s; ");
    webAddTag("styleTag", "}");

    webAddTag("styleTag", "input:checked+.slider {");
    webAddTag("styleTag", "   background-color: rgb(21, 150, 255);");
    webAddTag("styleTag", "}");

    webAddTag("styleTag", "input:focus+.slider {");
    webAddTag("styleTag", "   box-shadow: 0 0 1px rgb(21, 150, 255);");
    webAddTag("styleTag", "}");

    webAddTag("styleTag", "input:checked+.slider:before {");
    webAddTag("styleTag", "   -webkit-transform: translateX(24px);");
    webAddTag("styleTag", "   -ms-transform: translateX(24px); ");
    webAddTag("styleTag", "   transform: translateX(24px);");
    webAddTag("styleTag", "}");

    webAddTag("styleTag", ".slider.round {");
    webAddTag("styleTag", "   border-radius: 34px;");
    webAddTag("styleTag", "}");

    webAddTag("styleTag", ".slider.round:before {");
    webAddTag("styleTag", "    border-radius: 50%; ");
    webAddTag("styleTag", "}");*/

/*    webAddTag("styleTag", "table {");
    webAddTag("styleTag", "   margin-left: auto;");
    webAddTag("styleTag", "   margin-right: auto; ");
    webAddTag("styleTag", "   width: 75%;");
    webAddTag("styleTag", "}");

    webAddTag("styleTag", "table th {");
    webAddTag("styleTag", "    height: 35px;");
    webAddTag("styleTag", "   color: rgb(0, 0, 0);");
    webAddTag("styleTag", "   text-align: center;");
    webAddTag("styleTag", "   font-weight: bold; ");
    webAddTag("styleTag", "    font-size: 1rem;");
    webAddTag("styleTag", "}");

    webAddTag("styleTag", "table td {");
    webAddTag("styleTag", "    height: 35px;");
    webAddTag("styleTag", "    color: rgb(6, 6, 6);");
    webAddTag("styleTag", "    text-align: center;");
    webAddTag("styleTag", "    font-weight: bold; ");
    webAddTag("styleTag", "    font-size: 1rem;");
    webAddTag("styleTag", "}");*/

    webAddTag("styleTag", ".colorBox {");
    webAddTag("styleTag", "   float: left;");
    webAddTag("styleTag", "   width: 100%; ");
    webAddTag("styleTag", "   height: 1rem;");
    webAddTag("styleTag", "   border: 1px;");
    webAddTag("styleTag", "   solid rgba(0, 0, 0, .2);");
    webAddTag("styleTag", "}");
}